/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlDataListDownloader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDataListDownloader.class);
    private String path;
    private XPathExpression xpathExpr;
    private XmlDataFactory<T> dataFactory;
    private boolean readAttributes = false;

    public void setReadAttributes(boolean readAttributes) {
        this.readAttributes = readAttributes;
    }

    public void setPath(String path) {
        this.path = path;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            this.xpathExpr = xpath.compile(path);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataFactory(XmlDataFactory<T> dataFactory) {
        this.dataFactory = dataFactory;
    }

    public List<T> download(String url, boolean zip) {
        try {
            URL url2 = new URL(url);
            String proto = url2.getProtocol();
            InputStream inputStream = proto.equals("http") || proto.equals("https") ? HttpUtils.getData(url) : url2.openStream();
            if (inputStream == null) {
                LOG.warn("Failed to get data from url {}", (Object)url);
                return null;
            }
            if (zip) {
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                zipInputStream.getNextEntry();
                inputStream = zipInputStream;
            }
            return this.parseXML(inputStream);
        }
        catch (IOException e) {
            LOG.warn("Error reading XML feed from {}", (Object)url, (Object)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.warn("Error parsing XML feed from {} (bad XML of some sort)", (Object)url, (Object)e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.path + ")";
    }

    private List<T> parseXML(InputStream data) throws ParserConfigurationException, SAXException, IOException {
        NodeList nodes;
        ArrayList<T> out = new ArrayList<T>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(data);
        try {
            Object result = this.xpathExpr.evaluate(doc, XPathConstants.NODESET);
            nodes = (NodeList)result;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            T t;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            HashMap<String, String> attributes = new HashMap<String, String>();
            Node child = node.getFirstChild();
            if (this.readAttributes) {
                int lastAttr;
                NamedNodeMap attrs = node.getAttributes();
                int j = lastAttr = attrs.getLength() - 1;
                while (j-- > 0) {
                    Attr attr = (Attr)attrs.item(j);
                    attributes.put(attr.getNodeName(), attr.getNodeValue());
                }
            } else {
                while (child != null) {
                    if (!(child instanceof Element)) {
                        child = child.getNextSibling();
                        continue;
                    }
                    attributes.put(child.getNodeName(), child.getTextContent());
                    child = child.getNextSibling();
                }
            }
            if ((t = this.dataFactory.build(attributes)) == null) continue;
            out.add(t);
        }
        return out;
    }

    public static interface XmlDataFactory<T> {
        public T build(Map<String, String> var1);
    }
}

