/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.opentripplanner.util.logging.ProgressTracker;

class ProgressTrackerInputStream
extends InputStream {
    private final ProgressTracker progress;
    private final Consumer<String> logger;
    private final InputStream delegate;

    public ProgressTrackerInputStream(ProgressTracker progress, InputStream delegate, Consumer<String> logger) {
        this.progress = progress;
        this.delegate = delegate;
        this.logger = logger;
        this.logger.accept(this.progress.startMessage());
    }

    @Override
    public int read() throws IOException {
        int read = this.delegate.read();
        this.progress.step(this.logger);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = this.delegate.read(b);
        this.progress.steps(size, this.logger);
        return size;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size = this.delegate.read(b, off, len);
        this.progress.steps(size, this.logger);
        return size;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        byte[] bytes = this.delegate.readAllBytes();
        this.progress.steps(bytes.length, this.logger);
        return bytes;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        byte[] bytes = this.delegate.readNBytes(len);
        this.progress.steps(bytes.length, this.logger);
        return bytes;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        int size = this.delegate.readNBytes(b, off, len);
        this.progress.steps(size, this.logger);
        return size;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.logger.accept(this.progress.completeMessage());
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.delegate.transferTo(out);
    }
}

