/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.lang;

import java.util.function.Function;
import javax.annotation.Nullable;

public class ObjectUtils {
    @Nullable
    public static <T> T ifNotNull(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    @Nullable
    public static <E, T> T ifNotNull(@Nullable E entity, Function<E, T> getter, @Nullable T defaultValue) {
        if (entity == null) {
            return defaultValue;
        }
        return ObjectUtils.ifNotNull(getter.apply(entity), defaultValue);
    }

    public static <T> T requireNotInitialized(T oldValue, T newValue) {
        if (oldValue != null) {
            throw new IllegalStateException("Field is already set! Old value: " + oldValue + ", new value: " + newValue);
        }
        return newValue;
    }

    public static String toString(Object object) {
        return object == null ? "" : object.toString();
    }
}

