/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.lang;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class CollectionsView<T>
extends AbstractCollection<T>
implements Collection<T>,
Serializable {
    private final Collection<? extends T>[] collections;

    @SafeVarargs
    public CollectionsView(Collection<? extends T> ... collections) {
        this.collections = collections;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;
            Iterator<? extends T> it;
            {
                this.it = CollectionsView.this.collections[0].iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.i == CollectionsView.this.collections.length) {
                    return false;
                }
                if (this.it.hasNext()) {
                    return true;
                }
                ++this.i;
                while (this.i != CollectionsView.this.collections.length) {
                    this.it = CollectionsView.this.collections[this.i].iterator();
                    if (this.it.hasNext()) {
                        return true;
                    }
                    ++this.i;
                }
                this.it = null;
                return false;
            }

            @Override
            public T next() {
                return this.it.next();
            }
        };
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<T> collection : this.collections) {
            size += collection.size();
        }
        return size;
    }
}

