/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class WorldEnvelope
implements Serializable {
    Envelope leftEnv;
    Envelope rightEnv;
    double aRightCoordinate;
    private double lowerLeftLongitude;
    private double lowerLeftLatitude;
    private double upperRightLongitude;
    private double upperRightLatitude;
    boolean coordinatesCalculated = false;

    public WorldEnvelope() {
        this.leftEnv = new Envelope();
        this.rightEnv = new Envelope();
        this.aRightCoordinate = 0.0;
    }

    public WorldEnvelope(WorldEnvelope envelope) {
        this.leftEnv = envelope.leftEnv;
        this.rightEnv = envelope.rightEnv;
        this.aRightCoordinate = envelope.aRightCoordinate;
        this.coordinatesCalculated = false;
    }

    public void expandToInclude(Coordinate c) {
        this.expandToInclude(c.x, c.y);
    }

    public void expandToInclude(double x, double y) {
        if (x < 0.0) {
            this.leftEnv.expandToInclude(x, y);
        } else {
            this.rightEnv.expandToInclude(x, y);
            this.aRightCoordinate = x;
        }
    }

    public double getLowerLeftLongitude() {
        this.calculateCoordinates();
        return this.lowerLeftLongitude;
    }

    public double getLowerLeftLatitude() {
        this.calculateCoordinates();
        return this.lowerLeftLatitude;
    }

    public double getUpperRightLongitude() {
        this.calculateCoordinates();
        return this.upperRightLongitude;
    }

    public double getUpperRightLatitude() {
        this.calculateCoordinates();
        return this.upperRightLatitude;
    }

    public boolean contains(Coordinate c) {
        if (c.x < 0.0) {
            return this.leftEnv.contains(c);
        }
        return this.rightEnv.contains(c);
    }

    private void calculateCoordinates() {
        if (this.coordinatesCalculated) {
            return;
        }
        if (this.leftEnv.getArea() == 0.0) {
            this.lowerLeftLongitude = this.rightEnv.getMinX();
            this.upperRightLongitude = this.rightEnv.getMaxX();
            this.lowerLeftLatitude = this.rightEnv.getMinY();
            this.upperRightLatitude = this.rightEnv.getMaxY();
        } else if (this.rightEnv.getArea() == 0.0) {
            this.lowerLeftLongitude = this.leftEnv.getMinX();
            this.upperRightLongitude = this.leftEnv.getMaxX();
            this.lowerLeftLatitude = this.leftEnv.getMinY();
            this.upperRightLatitude = this.leftEnv.getMaxY();
        } else {
            if (this.aRightCoordinate < 90.0) {
                this.lowerLeftLongitude = this.leftEnv.getMinX();
                this.upperRightLongitude = this.rightEnv.getMaxX();
            } else {
                this.lowerLeftLongitude = this.leftEnv.getMaxX();
                this.upperRightLongitude = this.rightEnv.getMinX();
            }
            this.upperRightLatitude = Math.max(this.rightEnv.getMaxY(), this.leftEnv.getMaxY());
            this.lowerLeftLatitude = Math.min(this.rightEnv.getMinY(), this.leftEnv.getMinY());
        }
        this.coordinatesCalculated = true;
    }
}

