/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opentripplanner.api.parameter.ApiRequestMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.TravelOption;

public final class TravelOptionsMaker {
    private static final List<TravelOption> staticTravelOptions = new ArrayList<TravelOption>(3);

    public static List<TravelOption> makeOptions(Graph graph, TransitService transitService) {
        return TravelOptionsMaker.makeOptions(transitService.getTransitModes(), graph.hasBikeSharing, graph.hasBikeRide, graph.hasParkRide);
    }

    public static List<TravelOption> makeOptions(Set<TransitMode> transitModes, boolean hasBikeSharing, boolean hasBikeRide, boolean hasParkRide) {
        ArrayList<TravelOption> travelOptions = new ArrayList<TravelOption>(16);
        if (!transitModes.isEmpty()) {
            travelOptions.add(new TravelOption(String.join((CharSequence)",", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.WALK.toString()), ApiRequestMode.TRANSIT.toString()));
            for (TransitMode transitMode : transitModes) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", transitMode.toString(), ApiRequestMode.WALK.toString()), transitMode.toString()));
            }
        }
        travelOptions.addAll(staticTravelOptions);
        if (hasBikeSharing) {
            travelOptions.add(new TravelOption(String.join((CharSequence)",", ApiRequestMode.WALK.toString(), "BICYCLE_RENT"), "BICYCLERENT"));
        }
        if (!transitModes.isEmpty()) {
            travelOptions.add(new TravelOption(String.join((CharSequence)",", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.BICYCLE.toString()), String.join((CharSequence)"_", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.BICYCLE.toString())));
            if (hasBikeSharing) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.WALK.toString(), "BICYCLE_RENT"), "TRANSIT_BICYCLERENT"));
            }
            if (hasParkRide) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", "CAR_PARK", ApiRequestMode.WALK.toString(), ApiRequestMode.TRANSIT.toString()), "PARKRIDE"));
            }
            if (hasBikeRide) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", "BICYCLE_PARK", ApiRequestMode.WALK.toString(), ApiRequestMode.TRANSIT.toString()), "BIKERIDE"));
            }
            travelOptions.add(new TravelOption(String.join((CharSequence)",", ApiRequestMode.CAR.toString(), ApiRequestMode.WALK.toString(), ApiRequestMode.TRANSIT.toString()), "KISSRIDE"));
        }
        return travelOptions;
    }

    static {
        staticTravelOptions.add(new TravelOption(ApiRequestMode.WALK.toString()));
        staticTravelOptions.add(new TravelOption(ApiRequestMode.BICYCLE.toString()));
        staticTravelOptions.add(new TravelOption(ApiRequestMode.CAR.toString()));
    }
}

