/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.util.model.EncodedPolyline;

public class PolylineEncoder {
    public static EncodedPolyline encodeGeometry(Geometry geometry) {
        if (geometry instanceof LineString) {
            LineString string = (LineString)geometry;
            return PolylineEncoder.encodeCoordinates(string.getCoordinates());
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)geometry;
            return PolylineEncoder.encodeCoordinates(mls.getCoordinates());
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return PolylineEncoder.encodeCoordinates(polygon.getCoordinates());
        }
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return PolylineEncoder.encodeCoordinates(point.getCoordinates());
        }
        throw new IllegalArgumentException(geometry.toString());
    }

    static EncodedPolyline encodeCoordinates(Coordinate[] points) {
        StringBuilder encodedPoints = new StringBuilder();
        int plat = 0;
        int plng = 0;
        int count = 0;
        for (Coordinate point : points) {
            int late5 = PolylineEncoder.floor1e5(point.y);
            int lnge5 = PolylineEncoder.floor1e5(point.x);
            int dlat = late5 - plat;
            int dlng = lnge5 - plng;
            plat = late5;
            plng = lnge5;
            encodedPoints.append(PolylineEncoder.encodeSignedNumber(dlat)).append(PolylineEncoder.encodeSignedNumber(dlng));
            ++count;
        }
        return new EncodedPolyline(encodedPoints.toString(), count);
    }

    private static String encodeSignedNumber(int num) {
        int sgn_num = num << 1;
        if (num < 0) {
            sgn_num ^= 0xFFFFFFFF;
        }
        return PolylineEncoder.encodeNumber(sgn_num);
    }

    private static String encodeNumber(int num) {
        StringBuilder encodeString = new StringBuilder();
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            encodeString.append((char)nextValue);
            num >>= 5;
        }
        encodeString.append((char)(num += 63));
        return encodeString.toString();
    }

    private static int floor1e5(double coordinate) {
        return (int)Math.floor(coordinate * 100000.0);
    }
}

