/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpToGraphQLMapper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpToGraphQLMapper.class);

    public static Response mapExecutionResultToHttpResponse(ExecutionResult executionResult) {
        Response.ResponseBuilder res = Response.status((Response.Status)Response.Status.OK);
        HashMap<String, Object> content = new HashMap<String, Object>();
        if (!executionResult.getErrors().isEmpty()) {
            res = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            content.put("errors", executionResult.getErrors());
        }
        if (executionResult.getData() != null) {
            content.put("data", executionResult.getData());
        }
        return res.entity(content).build();
    }

    public static QlRequestParams mapHttpQuerryParamsToQLParams(Map<String, Object> queryParameters, ObjectMapper deserializer) {
        Map<String, Object> variables;
        String query = (String)queryParameters.get("query");
        Object queryVariables = queryParameters.getOrDefault("variables", null);
        String operationName = queryParameters.getOrDefault("operationName", null);
        if (queryVariables instanceof Map) {
            variables = queryVariables;
        } else if (queryVariables instanceof String && !((String)queryVariables).isEmpty()) {
            try {
                variables = (Map)deserializer.readValue((String)queryVariables, Map.class);
            }
            catch (IOException e) {
                throw new BadRequestException("Variables must be a valid json object");
            }
        } else {
            variables = new HashMap<String, Object>();
        }
        return new QlRequestParams(query, operationName, variables);
    }

    public static class QlRequestParams {
        public final String query;
        public final String operationName;
        public final Map<String, Object> variables;

        private QlRequestParams(String query, String operationName, Map<String, Object> variables) {
            this.query = query;
            this.operationName = operationName;
            this.variables = variables;
        }
    }
}

