/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_position;

import com.google.transit.realtime.GtfsRealtime;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.opentripplanner.routing.services.RealtimeVehiclePositionService;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitModelIndex;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.vehicle_position.GtfsRealtimeHttpVehiclePositionSource;
import org.opentripplanner.updater.vehicle_position.VehiclePositionPatternMatcher;
import org.opentripplanner.updater.vehicle_position.VehiclePositionSource;
import org.opentripplanner.updater.vehicle_position.VehiclePositionUpdaterRunnable;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingVehiclePositionUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingVehiclePositionUpdater.class);
    private final VehiclePositionSource vehiclePositionSource;
    private final VehiclePositionPatternMatcher vehiclePositionPatternMatcher;
    private WriteToGraphCallback saveResultOnGraph;

    public PollingVehiclePositionUpdater(VehiclePositionsUpdaterParameters params, RealtimeVehiclePositionService vehiclePositionService, TransitModel transitModel) {
        super(params);
        this.vehiclePositionSource = new GtfsRealtimeHttpVehiclePositionSource(params.url());
        TransitModelIndex index = transitModel.getTransitModelIndex();
        this.vehiclePositionPatternMatcher = new VehiclePositionPatternMatcher(params.feedId(), tripId -> index.getTripForId().get(tripId), trip -> index.getPatternForTrip().get(trip), (trip, date) -> PollingVehiclePositionUpdater.getPatternIncludingRealtime(transitModel, trip, date), vehiclePositionService, transitModel.getTimeZone());
        LOG.info("Creating vehicle position updater running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.vehiclePositionSource);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void runPolling() {
        List<GtfsRealtime.VehiclePosition> updates = this.vehiclePositionSource.getPositions();
        if (updates != null) {
            VehiclePositionUpdaterRunnable runnable = new VehiclePositionUpdaterRunnable(updates, this.vehiclePositionPatternMatcher);
            this.saveResultOnGraph.execute(runnable);
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("source", this.vehiclePositionSource).toString();
    }

    private static TripPattern getPatternIncludingRealtime(TransitModel transitModel, Trip trip, LocalDate sd) {
        return Optional.ofNullable(transitModel.getTimetableSnapshot()).map(snapshot -> snapshot.getRealtimeAddedTripPattern(trip.getId(), sd)).orElseGet(() -> transitModel.getTransitModelIndex().getPatternForTrip().get(trip));
    }
}

