/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_position;

import com.google.transit.realtime.GtfsRealtime;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.opentripplanner.updater.vehicle_position.VehiclePositionSource;
import org.opentripplanner.util.HttpUtils;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeHttpVehiclePositionSource
implements VehiclePositionSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeHttpVehiclePositionSource.class);
    private final URI url;
    private final Map<String, String> defaultHeaders = Map.of("Accept", "application/x-google-protobuf, application/x-protobuf, application/protobuf, application/octet-stream, */*");

    public GtfsRealtimeHttpVehiclePositionSource(URI url) {
        this.url = url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<GtfsRealtime.VehiclePosition> getPositions() {
        try (InputStream is = HttpUtils.openInputStream(this.url.toString(), this.defaultHeaders);){
            if (is == null) {
                LOG.warn("Failed to get data from url {}", (Object)this.url);
                List<GtfsRealtime.VehiclePosition> list2 = List.of();
                return list2;
            }
            List<GtfsRealtime.VehiclePosition> list = this.getPositions(is);
            return list;
        }
        catch (IOException e) {
            LOG.warn("Error reading vehicle positions from {}", (Object)this.url, (Object)e);
            return List.of();
        }
    }

    public String toString() {
        return ToStringBuilder.of(GtfsRealtimeHttpVehiclePositionSource.class).addObj("url", this.url).toString();
    }
}

