/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.updater.trip.UpdateResult;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;

public class StreamingTripUpdateMetrics
extends TripUpdateMetrics {
    protected static final String METRICS_PREFIX = "streaming_trip_updates";
    private final Counter successfulCounter;
    private final Counter failureCounter;
    private final Map<UpdateError.UpdateErrorType, Counter> failuresByType = new HashMap<UpdateError.UpdateErrorType, Counter>();

    public StreamingTripUpdateMetrics(UrlUpdaterParameters parameters) {
        super(parameters);
        this.successfulCounter = this.getCounter("successful", "Total successfully applied trip updates", new Tag[0]);
        this.failureCounter = this.getCounter("failed", "Total failed trip updates", new Tag[0]);
    }

    public void setCounters(UpdateResult result) {
        this.successfulCounter.increment((double)result.successful());
        this.failureCounter.increment((double)result.failed());
        for (UpdateError.UpdateErrorType errorType : result.failures().keySet()) {
            Counter counter = this.failuresByType.get((Object)errorType);
            if (Objects.isNull(counter)) {
                counter = this.getCounter("failure_type", "Total failed trip updates by type", Tag.of((String)"errorType", (String)errorType.name()));
                this.failuresByType.put(errorType, counter);
            }
            counter.increment((double)result.failures().get((Object)errorType).size());
        }
    }

    private Counter getCounter(String name, String description, Tag ... tags) {
        Tags finalTags = Tags.concat(Arrays.stream(tags).toList(), (Iterable)this.baseTags);
        return Counter.builder((String)("streaming_trip_updates." + name)).description(description).tags((Iterable)finalTags).register((MeterRegistry)Metrics.globalRegistry);
    }
}

