/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.updater.trip.UpdateResult;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;

public class BatchTripUpdateMetrics
extends TripUpdateMetrics {
    protected static final String METRICS_PREFIX = "batch_trip_updates";
    private final AtomicInteger successfulGauge;
    private final AtomicInteger failureGauge;
    private final Map<UpdateError.UpdateErrorType, AtomicInteger> failuresByType = new HashMap<UpdateError.UpdateErrorType, AtomicInteger>();

    public BatchTripUpdateMetrics(UrlUpdaterParameters parameters) {
        super(parameters);
        this.successfulGauge = this.getGauge("successful", "Trip updates that were successfully applied at the most recent update", new Tag[0]);
        this.failureGauge = this.getGauge("failed", "Trip updates that failed to apply at the most recent update", new Tag[0]);
    }

    public void setGauges(UpdateResult result) {
        this.successfulGauge.set(result.successful());
        this.failureGauge.set(result.failed());
        for (UpdateError.UpdateErrorType errorType : result.failures().keySet()) {
            AtomicInteger counter = this.failuresByType.get((Object)errorType);
            if (Objects.isNull(counter)) {
                counter = this.getGauge("failure_type", "Failure types of the most recent update", Tag.of((String)"errorType", (String)errorType.name()));
                this.failuresByType.put(errorType, counter);
            }
            counter.set(result.failures().get((Object)errorType).size());
        }
        HashSet<UpdateError.UpdateErrorType> toZero = new HashSet<UpdateError.UpdateErrorType>(this.failuresByType.keySet());
        toZero.removeAll(result.failures().keySet());
        for (UpdateError.UpdateErrorType keyToZero : toZero) {
            this.failuresByType.get((Object)keyToZero).set(0);
        }
    }

    private AtomicInteger getGauge(String name, String description, Tag ... tags) {
        Tags finalTags = Tags.concat(Arrays.stream(tags).toList(), (Iterable)this.baseTags);
        AtomicInteger atomicInt = new AtomicInteger(0);
        Gauge.builder((String)("batch_trip_updates." + name), atomicInt::get).description(description).tags((Iterable)finalTags).register((MeterRegistry)Metrics.globalRegistry);
        return atomicInt;
    }
}

