/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.transit.model.framework.Result;

public record UpdateResult(int successful, int failed, Multimap<UpdateError.UpdateErrorType, UpdateError> failures) {
    public static UpdateResult empty() {
        return new UpdateResult(0, 0, (Multimap<UpdateError.UpdateErrorType, UpdateError>)ArrayListMultimap.create());
    }

    public static UpdateResult ofResults(List<Result<?, UpdateError>> results) {
        List<UpdateError> errors = results.stream().filter(Result::isFailure).map(Result::failureValue).toList();
        long successfullyApplied = results.stream().filter(Result::isSuccess).count();
        ImmutableListMultimap errorIndex = Multimaps.index(errors, UpdateError::errorType);
        return new UpdateResult((int)successfullyApplied, errors.size(), (Multimap<UpdateError.UpdateErrorType, UpdateError>)errorIndex);
    }
}

