/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.transit.realtime.GtfsRealtime;
import java.util.List;
import java.util.function.Consumer;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.GtfsRealtimeFileTripUpdateSource;
import org.opentripplanner.updater.trip.GtfsRealtimeHttpTripUpdateSource;
import org.opentripplanner.updater.trip.PollingTripUpdaterParameters;
import org.opentripplanner.updater.trip.TimetableSnapshotSource;
import org.opentripplanner.updater.trip.TripUpdateGraphWriterRunnable;
import org.opentripplanner.updater.trip.TripUpdateSource;
import org.opentripplanner.updater.trip.UpdateResult;
import org.opentripplanner.updater.trip.metrics.BatchTripUpdateMetrics;
import org.opentripplanner.util.lang.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingTripUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingTripUpdater.class);
    private final TripUpdateSource updateSource;
    private final TimetableSnapshotSource snapshotSource;
    private final String feedId;
    private final BackwardsDelayPropagationType backwardsDelayPropagationType;
    private final Consumer<UpdateResult> recordMetrics;
    private WriteToGraphCallback saveResultOnGraph;
    private GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher;

    public PollingTripUpdater(PollingTripUpdaterParameters parameters, TransitModel transitModel, TimetableSnapshotSource snapshotSource) {
        super(parameters);
        this.feedId = parameters.getFeedId();
        this.updateSource = PollingTripUpdater.createSource(parameters);
        this.backwardsDelayPropagationType = parameters.getBackwardsDelayPropagationType();
        this.snapshotSource = snapshotSource;
        if (parameters.fuzzyTripMatching()) {
            this.fuzzyTripMatcher = new GtfsRealtimeFuzzyTripMatcher(new DefaultTransitService(transitModel));
        }
        this.recordMetrics = BatchTripUpdateMetrics.batch(parameters);
        LOG.info("Creating stop time updater running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.updateSource);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void runPolling() {
        List<GtfsRealtime.TripUpdate> updates = this.updateSource.getUpdates();
        boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
        if (updates != null) {
            TripUpdateGraphWriterRunnable runnable = new TripUpdateGraphWriterRunnable(this.snapshotSource, this.fuzzyTripMatcher, this.backwardsDelayPropagationType, fullDataset, updates, this.feedId, this.recordMetrics);
            this.saveResultOnGraph.execute(runnable);
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("updateSource", this.updateSource).addStr("feedId", this.feedId).addBoolIfTrue("fuzzyTripMatching", this.fuzzyTripMatcher != null).toString();
    }

    private static TripUpdateSource createSource(PollingTripUpdaterParameters parameters) {
        if (parameters.httpSourceParameters().getUrl() != null) {
            return new GtfsRealtimeHttpTripUpdateSource(parameters.httpSourceParameters());
        }
        if (parameters.fileSourceParameters().getFile() != null) {
            return new GtfsRealtimeFileTripUpdateSource(parameters.fileSourceParameters());
        }
        throw new IllegalArgumentException("Need either a url or file argument to construct a" + PollingTripUpdater.class.getSimpleName());
    }
}

