/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.transit.realtime.GtfsRealtime;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.updater.trip.TripUpdateSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeFileTripUpdateSource
implements TripUpdateSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeFileTripUpdateSource.class);
    private final File file;
    private final String feedId = this.getFeedId();
    private boolean fullDataset = true;

    public GtfsRealtimeFileTripUpdateSource(Parameters config) {
        this.file = new File(config.getFile());
    }

    @Override
    public List<GtfsRealtime.TripUpdate> getUpdates() {
        GtfsRealtime.FeedMessage feedMessage = null;
        List<GtfsRealtime.FeedEntity> feedEntityList = null;
        ArrayList<GtfsRealtime.TripUpdate> updates = null;
        this.fullDataset = true;
        try {
            FileInputStream is = new FileInputStream(this.file);
            feedMessage = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom((InputStream)is);
            feedEntityList = feedMessage.getEntityList();
            if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                this.fullDataset = false;
            }
            updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
            for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                if (!feedEntity.hasTripUpdate()) continue;
                updates.add(feedEntity.getTripUpdate());
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to parse gtfs-rt feed at {}", (Object)this.file, (Object)e);
        }
        return updates;
    }

    @Override
    public boolean getFullDatasetValueOfLastUpdates() {
        return this.fullDataset;
    }

    @Override
    public String getFeedId() {
        return this.feedId;
    }

    public String toString() {
        return "GtfsRealtimeFileTripUpdateSource(" + this.file + ")";
    }

    public static interface Parameters {
        public String getFeedId();

        public String getFile();
    }
}

