/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.GraphUpdaterStatus;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUpdaterManager
implements WriteToGraphCallback,
GraphUpdaterStatus {
    private static final Logger LOG = LoggerFactory.getLogger(GraphUpdaterManager.class);
    private final ScheduledExecutorService scheduler;
    private final ExecutorService updaterPool;
    private final List<GraphUpdater> updaterList = new ArrayList<GraphUpdater>();
    private final Graph graph;
    private final TransitModel transitModel;

    public GraphUpdaterManager(Graph graph, TransitModel transitModel, List<GraphUpdater> updaters) {
        this.graph = graph;
        this.transitModel = transitModel;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("GraphUpdater-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.updaterPool = Executors.newCachedThreadPool(threadFactory);
        for (GraphUpdater updater : updaters) {
            this.updaterList.add(updater);
            updater.setGraphUpdaterManager(this);
        }
    }

    public void startUpdaters() {
        for (GraphUpdater updater : this.updaterList) {
            LOG.info("Starting new thread for updater {}", (Object)updater.toString());
            this.updaterPool.execute(() -> {
                try {
                    updater.run();
                }
                catch (Exception e) {
                    LOG.error("Error while running updater {}:", (Object)updater.getClass().getName(), (Object)e);
                }
            });
        }
        this.reportReadinessForUpdaters();
    }

    public void stop() {
        this.updaterPool.shutdownNow();
        try {
            boolean ok = this.updaterPool.awaitTermination(30L, TimeUnit.SECONDS);
            if (!ok) {
                LOG.warn("Timeout waiting for updaters to finish.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for updaters to finish.");
        }
        for (GraphUpdater updater : this.updaterList) {
            updater.teardown();
        }
        this.updaterList.clear();
        this.scheduler.shutdownNow();
        try {
            boolean ok = this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
            if (!ok) {
                LOG.warn("Timeout waiting for scheduled task to finish.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for scheduled task to finish.");
        }
    }

    @Override
    public Future<?> execute(GraphWriterRunnable runnable) {
        return this.scheduler.submit(() -> {
            try {
                runnable.run(this.graph, this.transitModel);
            }
            catch (Exception e) {
                LOG.error("Error while running graph writer {}:", (Object)runnable.getClass().getName(), (Object)e);
            }
        });
    }

    @Override
    public int numberOfUpdaters() {
        return this.updaterList.size();
    }

    @Override
    public List<String> listUnprimedUpdaters() {
        return this.updaterList.stream().filter(Predicate.not(GraphUpdater::isPrimed)).map(GraphUpdater::getConfigRef).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, String> getUpdaterDescriptions() {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        int i = 0;
        for (GraphUpdater updater : this.updaterList) {
            ret.put(i++, updater.toString());
        }
        return ret;
    }

    public GraphUpdater getUpdater(int id) {
        if (id >= this.updaterList.size()) {
            return null;
        }
        return this.updaterList.get(id);
    }

    @Override
    public Class<?> getUpdaterClass(int id) {
        GraphUpdater updater = this.getUpdater(id);
        return updater == null ? null : updater.getClass();
    }

    public List<GraphUpdater> getUpdaterList() {
        return this.updaterList;
    }

    public ExecutorService getUpdaterPool() {
        return this.updaterPool;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    private void reportReadinessForUpdaters() {
        Executors.newSingleThreadExecutor().submit(() -> {
            while (true) {
                try {
                    while (true) {
                        if (this.updaterList.stream().allMatch(GraphUpdater::isPrimed)) {
                            LOG.info("OTP UPDATERS INITIALIZED - OTP is ready for routing!");
                            return;
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }
}

