/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.util.xml.JsonDataListDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericJsonDataSource<T>
implements DataSource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericJsonDataSource.class);
    private final JsonDataListDownloader<T> jsonDataListDownloader;
    private String url;
    protected List<T> updates = List.of();

    public GenericJsonDataSource(String url, String jsonParsePath, Map<String, String> headers) {
        this.url = url;
        this.jsonDataListDownloader = new JsonDataListDownloader<Object>(url, jsonParsePath, this::parseElement, headers);
    }

    public GenericJsonDataSource(String url, String jsonParsePath) {
        this(url, jsonParsePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        List<T> updates = this.jsonDataListDownloader.download();
        if (updates != null) {
            GenericJsonDataSource genericJsonDataSource = this;
            synchronized (genericJsonDataSource) {
                this.updates = updates;
            }
            return true;
        }
        LOG.info("Can't update entities from: {}, keeping current list.", (Object)this.url);
        return false;
    }

    @Override
    public List<T> getUpdates() {
        return this.updates;
    }

    public void setUrl(String url) {
        this.url = url;
        this.jsonDataListDownloader.setUrl(url);
    }

    protected abstract T parseElement(JsonNode var1);
}

