/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitModelIndex {
    private static final Logger LOG = LoggerFactory.getLogger(TransitModelIndex.class);
    private final Map<FeedScopedId, Agency> agencyForId = new HashMap<FeedScopedId, Agency>();
    private final Map<FeedScopedId, Operator> operatorForId = new HashMap<FeedScopedId, Operator>();
    private final Map<FeedScopedId, Trip> tripForId = new HashMap<FeedScopedId, Trip>();
    private final Map<FeedScopedId, Route> routeForId = new HashMap<FeedScopedId, Route>();
    private final Map<Trip, TripPattern> patternForTrip = new HashMap<Trip, TripPattern>();
    private final Multimap<Route, TripPattern> patternsForRoute = ArrayListMultimap.create();
    private final Multimap<StopLocation, TripPattern> patternsForStopId = ArrayListMultimap.create();
    private final Map<LocalDate, TIntSet> serviceCodesRunningForDate = new HashMap<LocalDate, TIntSet>();
    private final Map<FeedScopedId, TripOnServiceDate> tripOnServiceDateById = new HashMap<FeedScopedId, TripOnServiceDate>();
    private final Map<TripIdAndServiceDate, TripOnServiceDate> tripOnServiceDateForTripAndDay = new HashMap<TripIdAndServiceDate, TripOnServiceDate>();
    private final Multimap<GroupOfRoutes, Route> routesForGroupOfRoutes = ArrayListMultimap.create();
    private final Map<FeedScopedId, GroupOfRoutes> groupOfRoutesForId = new HashMap<FeedScopedId, GroupOfRoutes>();
    private FlexIndex flexIndex = null;

    TransitModelIndex(TransitModel transitModel) {
        LOG.info("Transit model index init...");
        for (Agency agency : transitModel.getAgencies()) {
            this.agencyForId.put(agency.getId(), agency);
        }
        for (Operator operator : transitModel.getOperators()) {
            this.operatorForId.put(operator.getId(), operator);
        }
        for (TripPattern tripPattern : transitModel.getAllTripPatterns()) {
            this.patternsForRoute.put((Object)tripPattern.getRoute(), (Object)tripPattern);
            tripPattern.scheduledTripsAsStream().forEach(trip -> {
                this.patternForTrip.put((Trip)trip, pattern);
                this.tripForId.put(trip.getId(), (Trip)trip);
            });
            for (StopLocation stop : tripPattern.getStops()) {
                this.patternsForStopId.put((Object)stop, (Object)tripPattern);
            }
        }
        for (Route route : this.patternsForRoute.asMap().keySet()) {
            this.routeForId.put(route.getId(), route);
            for (GroupOfRoutes groupOfRoutes : route.getGroupsOfRoutes()) {
                this.routesForGroupOfRoutes.put((Object)groupOfRoutes, (Object)route);
            }
        }
        for (GroupOfRoutes groupOfRoutes : this.routesForGroupOfRoutes.keySet()) {
            this.groupOfRoutesForId.put(groupOfRoutes.getId(), groupOfRoutes);
        }
        for (TripOnServiceDate tripOnServiceDate : transitModel.getAllTripOnServiceDates()) {
            this.tripOnServiceDateById.put(tripOnServiceDate.getId(), tripOnServiceDate);
            this.tripOnServiceDateForTripAndDay.put(new TripIdAndServiceDate(tripOnServiceDate.getTrip().getId(), tripOnServiceDate.getServiceDate()), tripOnServiceDate);
        }
        this.initalizeServiceCodesForDate(transitModel);
        if (OTPFeature.FlexRouting.isOn()) {
            this.flexIndex = new FlexIndex(transitModel);
            for (Route route : this.flexIndex.getAllFlexRoutes()) {
                this.routeForId.put(route.getId(), route);
            }
            for (FlexTrip flexTrip : this.flexIndex.getAllFlexTrips()) {
                this.tripForId.put(flexTrip.getId(), flexTrip.getTrip());
            }
        }
        LOG.info("Transit Model index init complete.");
    }

    public Agency getAgencyForId(FeedScopedId id) {
        return this.agencyForId.get(id);
    }

    public Route getRouteForId(FeedScopedId id) {
        return this.routeForId.get(id);
    }

    public void addRoutes(Route route) {
        this.routeForId.put(route.getId(), route);
    }

    public Set<Route> getRoutesForStop(StopLocation stop) {
        HashSet<Route> routes = new HashSet<Route>();
        for (TripPattern p : this.getPatternsForStop(stop)) {
            routes.add(p.getRoute());
        }
        return routes;
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.patternsForStopId.get((Object)stop);
    }

    public Collection<Trip> getTripsForStop(StopLocation stop) {
        return this.getPatternsForStop(stop).stream().flatMap(TripPattern::scheduledTripsAsStream).collect(Collectors.toList());
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop, TimetableSnapshot timetableSnapshot) {
        HashSet<TripPattern> tripPatterns = new HashSet<TripPattern>(this.getPatternsForStop(stop));
        if (timetableSnapshot != null) {
            tripPatterns.addAll(timetableSnapshot.getPatternsForStop(stop));
        }
        return tripPatterns;
    }

    public Collection<Operator> getAllOperators() {
        return this.getOperatorForId().values();
    }

    public Map<FeedScopedId, Operator> getOperatorForId() {
        return this.operatorForId;
    }

    public Map<FeedScopedId, Trip> getTripForId() {
        return this.tripForId;
    }

    public Map<FeedScopedId, TripOnServiceDate> getTripOnServiceDateById() {
        return this.tripOnServiceDateById;
    }

    public Map<TripIdAndServiceDate, TripOnServiceDate> getTripOnServiceDateForTripAndDay() {
        return this.tripOnServiceDateForTripAndDay;
    }

    public Collection<Route> getAllRoutes() {
        return this.routeForId.values();
    }

    public Map<Trip, TripPattern> getPatternForTrip() {
        return this.patternForTrip;
    }

    public Multimap<Route, TripPattern> getPatternsForRoute() {
        return this.patternsForRoute;
    }

    public Map<LocalDate, TIntSet> getServiceCodesRunningForDate() {
        return this.serviceCodesRunningForDate;
    }

    public FlexIndex getFlexIndex() {
        return this.flexIndex;
    }

    private void initalizeServiceCodesForDate(TransitModel transitModel) {
        CalendarService calendarService = transitModel.getCalendarService();
        if (calendarService == null) {
            return;
        }
        HashMultimap serviceIdsForServiceDate = HashMultimap.create();
        for (FeedScopedId serviceId : calendarService.getServiceIds()) {
            Set<LocalDate> serviceDatesForService = calendarService.getServiceDatesForServiceId(serviceId);
            for (LocalDate serviceDate : serviceDatesForService) {
                serviceIdsForServiceDate.put((Object)serviceDate, (Object)serviceId);
            }
        }
        for (LocalDate serviceDate : serviceIdsForServiceDate.keySet()) {
            TIntHashSet serviceCodesRunning = new TIntHashSet();
            for (FeedScopedId serviceId : serviceIdsForServiceDate.get((Object)serviceDate)) {
                serviceCodesRunning.add(transitModel.getServiceCodes().get(serviceId).intValue());
            }
            this.serviceCodesRunningForDate.put(serviceDate, (TIntSet)serviceCodesRunning);
        }
    }

    public Multimap<GroupOfRoutes, Route> getRoutesForGroupOfRoutes() {
        return this.routesForGroupOfRoutes;
    }

    public Map<FeedScopedId, GroupOfRoutes> getGroupOfRoutesForId() {
        return this.groupOfRoutesForId;
    }
}

