/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupOfStations;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.util.MedianCalcForDoubles;
import org.opentripplanner.util.lang.CollectionsView;

public class StopModelBuilder {
    private final EntityById<RegularStop> regularStopById = new EntityById();
    private final EntityById<AreaStop> areaStopById = new EntityById();
    private final EntityById<GroupStop> groupStopById = new EntityById();
    private final EntityById<Station> stationById = new EntityById();
    private final EntityById<MultiModalStation> multiModalStationById = new EntityById();
    private final EntityById<GroupOfStations> groupOfStationById = new EntityById();

    StopModelBuilder() {
    }

    StopModelBuilder(StopModel stopModel) {
        this.addAll(stopModel);
    }

    public EntityById<RegularStop> regularStopsById() {
        return this.regularStopById;
    }

    public StopModelBuilder withRegularStop(RegularStop stop) {
        this.regularStopById.add(stop);
        return this;
    }

    public EntityById<Station> stationById() {
        return this.stationById;
    }

    public StopModelBuilder withStation(Station station) {
        this.stationById.add(station);
        return this;
    }

    public EntityById<MultiModalStation> multiModalStationById() {
        return this.multiModalStationById;
    }

    public StopModelBuilder withMultiModalStation(MultiModalStation station) {
        this.multiModalStationById.add(station);
        return this;
    }

    public EntityById<GroupOfStations> groupOfStationById() {
        return this.groupOfStationById;
    }

    public StopModelBuilder withGroupOfStation(GroupOfStations station) {
        this.groupOfStationById.add(station);
        return this;
    }

    public EntityById<AreaStop> areaStopById() {
        return this.areaStopById;
    }

    public StopModelBuilder withAreaStop(AreaStop stop) {
        this.areaStopById.add(stop);
        return this;
    }

    public EntityById<GroupStop> groupStopById() {
        return this.groupStopById;
    }

    public StopModelBuilder withGroupStop(GroupStop group) {
        this.groupStopById.add(group);
        return this;
    }

    public StopModelBuilder addAll(StopModel other) {
        this.regularStopById.addAll(other.listRegularStops());
        this.stationById.addAll(other.listStations());
        this.multiModalStationById.addAll(other.listMultiModalStations());
        this.groupOfStationById.addAll(other.listGroupOfStations());
        this.areaStopById.addAll(other.listAreaStops());
        this.groupStopById.addAll(other.listGroupStops());
        return this;
    }

    WgsCoordinate calculateTransitCenter() {
        CollectionsView<AbstractTransitEntity> stops = new CollectionsView<AbstractTransitEntity>(this.regularStopById.values(), this.areaStopById.values(), this.groupStopById.values());
        if (stops.isEmpty()) {
            return null;
        }
        MedianCalcForDoubles medianCalculator = new MedianCalcForDoubles(stops.size());
        stops.forEach(v -> medianCalculator.add(((StopLocation)((Object)v)).getLon()));
        double lon = medianCalculator.median();
        medianCalculator.reset();
        stops.forEach(v -> medianCalculator.add(((StopLocation)((Object)v)).getLat()));
        double lat = medianCalculator.median();
        return new WgsCoordinate(lat, lon);
    }

    public StopModel build() {
        return new StopModel(this);
    }
}

