/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.service;

import java.util.Comparator;
import org.opentripplanner.transit.raptor.api.debug.DebugLogger;
import org.opentripplanner.transit.raptor.api.debug.DebugTopic;
import org.opentripplanner.transit.raptor.api.request.DebugRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.transit.raptor.util.CompareIntArrays;
import org.opentripplanner.util.lang.IntUtils;

public class DebugHeuristics {
    private static final int UNREACHED = -9999;
    private final String aName;
    private final String bName;
    private final DebugLogger logger;
    private final int[] stops;

    private DebugHeuristics(String aName, String bName, DebugRequest debugRequest) {
        this.aName = aName;
        this.bName = bName;
        this.logger = debugRequest.logger();
        this.stops = IntUtils.concat(debugRequest.stops(), debugRequest.path());
    }

    public static void debug(String aName, Heuristics h1, String bName, Heuristics h2, RaptorRequest<?> request) {
        DebugRequest debug = request.debug();
        if (debug.logger().isEnabled()) {
            new DebugHeuristics(aName, bName, debug).debug(h1, h2, request.searchDirection());
        }
    }

    private void log(String message) {
        this.logger.debug(DebugTopic.HEURISTICS, message);
    }

    private void debug(Heuristics fwdHeur, Heuristics revHeur, SearchDirection direction) {
        this.log(CompareIntArrays.compare("NUMBER OF TRANSFERS", this.aName, fwdHeur.bestNumOfTransfersToIntArray(-9999), this.bName, revHeur.bestNumOfTransfersToIntArray(-9999), -9999, this.stops, Comparator.comparingInt(i -> i)));
        this.log(CompareIntArrays.compareTime("TRAVEL DURATION", this.aName, fwdHeur.bestTravelDurationToIntArray(-9999), this.bName, revHeur.bestTravelDurationToIntArray(-9999), -9999, this.stops, direction.isForward() ? Comparator.comparingInt(i -> i) : (l, r) -> r - l));
        this.log(CompareIntArrays.compareTime("GENERALIZED COST", this.aName, fwdHeur.bestGeneralizedCostToIntArray(-9999), this.bName, revHeur.bestGeneralizedCostToIntArray(-9999), -9999, this.stops, direction.isForward() ? Comparator.comparingInt(i -> i) : (l, r) -> r - l));
    }
}

