/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.transit;

import org.opentripplanner.transit.raptor.api.transit.BoardAndAlightTime;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.api.view.TransitPathView;
import org.opentripplanner.util.time.TimeUtils;

public class TripTimesSearch<T extends RaptorTripSchedule> {
    private final T schedule;
    private final int fromStop;
    private final int toStop;

    private TripTimesSearch(T schedule, int fromStop, int toStop) {
        this.schedule = schedule;
        this.fromStop = fromStop;
        this.toStop = toStop;
    }

    public static <S extends RaptorTripSchedule> BoardAndAlightTime findTripForwardSearch(ArrivalView<S> arrival) {
        TransitPathView<S> transit = arrival.transitPath();
        TripTimesSearch<S> search = new TripTimesSearch<S>(transit.trip(), transit.boardStop(), arrival.stop());
        return search.findTripTimesBefore(arrival.arrivalTime());
    }

    public static <S extends RaptorTripSchedule> BoardAndAlightTime findTripReverseSearch(ArrivalView<S> arrival) {
        TransitPathView<S> transit = arrival.transitPath();
        TripTimesSearch<S> search = new TripTimesSearch<S>(transit.trip(), arrival.stop(), transit.boardStop());
        return search.findTripTimesAfter(arrival.arrivalTime());
    }

    public static <S extends RaptorTripSchedule> BoardAndAlightTime findTripForwardSearchApproximateTime(ArrivalView<S> arrival) {
        TransitPathView<S> t = arrival.transitPath();
        return TripTimesSearch.findTripTimes(t.trip(), t.boardStop(), arrival.stop(), arrival.arrivalTime());
    }

    public static <S extends RaptorTripSchedule> BoardAndAlightTime findTripReverseSearchApproximateTime(ArrivalView<S> arrival) {
        TransitPathView<S> t = arrival.transitPath();
        return TripTimesSearch.findTripTimes(t.trip(), arrival.stop(), t.boardStop(), arrival.arrivalTime());
    }

    public static <S extends RaptorTripSchedule> BoardAndAlightTime findTripTimes(S trip, int fromStop, int toStop, int approximateTime) {
        TripTimesSearch<S> search = new TripTimesSearch<S>(trip, fromStop, toStop);
        return search.findTripByApproximateTime(approximateTime);
    }

    private BoardAndAlightTime findTripTimesAfter(int earliestDepartureTime) {
        RaptorTripPattern p = this.schedule.pattern();
        int size = p.numberOfStopsInPattern();
        int i = this.schedule.findDepartureStopPosition(earliestDepartureTime, this.fromStop);
        if (i < 0) {
            throw this.notFoundException("No stops matching 'fromStop'", "earliestDepartureTime", earliestDepartureTime);
        }
        int boardStopPos = i++;
        while (i < size && p.stopIndex(i) != this.toStop) {
            ++i;
        }
        if (i == size) {
            throw this.notFoundException("No stops matching 'toStop'", "earliestDepartureTime", earliestDepartureTime);
        }
        return new BoardAndAlightTime((RaptorTripSchedule)this.schedule, boardStopPos, i);
    }

    private BoardAndAlightTime findTripTimesBefore(int latestArrivalTime) {
        RaptorTripPattern p = this.schedule.pattern();
        int i = this.schedule.findArrivalStopPosition(latestArrivalTime, this.toStop);
        if (i < 0) {
            throw this.notFoundException("No stops matching 'toStop'", "latestArrivalTime", latestArrivalTime);
        }
        int alightStopPos = i--;
        while (i >= 0 && p.stopIndex(i) != this.fromStop) {
            --i;
        }
        if (i < 0) {
            throw this.notFoundException("No stops matching 'fromStop'", "latestArrivalTime", latestArrivalTime);
        }
        return new BoardAndAlightTime((RaptorTripSchedule)this.schedule, i, alightStopPos);
    }

    private BoardAndAlightTime findTripByApproximateTime(int approximateTime) {
        RaptorTripPattern p = this.schedule.pattern();
        int fromPos = this.stopPosAfter(p, 0, this.fromStop, approximateTime);
        int toPos = this.stopPosAfter(p, fromPos + 1, this.toStop, approximateTime);
        fromPos = this.stopPosBefore(p, toPos - 1, this.fromStop, approximateTime);
        try {
            while (true) {
                int nextFromPos = this.stopPosAfter(p, fromPos + 1, this.fromStop, approximateTime);
                int nextToPos = this.stopPosAfter(p, nextFromPos + 1, this.toStop, approximateTime);
                nextFromPos = this.stopPosBefore(p, nextToPos - 1, this.fromStop, approximateTime);
                int totTime = this.schedule.departure(fromPos) + this.schedule.arrival(toPos) + this.schedule.departure(nextFromPos) + this.schedule.arrival(nextToPos);
                if (totTime < 4 * approximateTime) {
                    fromPos = nextFromPos;
                    toPos = nextToPos;
                    continue;
                }
                break;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return new BoardAndAlightTime((RaptorTripSchedule)this.schedule, fromPos, toPos);
    }

    private int stopPosAfter(RaptorTripPattern p, int startPos, int stopIndex, int time) {
        int stopPos = p.findStopPositionAfter(startPos, stopIndex);
        return this.stopPosExist(stopPos, stopIndex, time);
    }

    private int stopPosBefore(RaptorTripPattern p, int startPos, int stopIndex, int time) {
        int stopPos = p.findStopPositionBefore(startPos, stopIndex);
        return this.stopPosExist(stopPos, stopIndex, time);
    }

    private int stopPosExist(int pos, int stop, int time) {
        if (pos < 0) {
            throw this.notFoundException("No stop matching " + stop, "approximateTime", time);
        }
        return pos;
    }

    private IllegalStateException notFoundException(String hint, String lbl, int time) {
        return new IllegalStateException("Trip not found: " + hint + ".  [FromStop: " + this.fromStop + ", toStop: " + this.toStop + ", " + lbl + ": " + TimeUtils.timeToStrLong(time) + ", pattern: " + this.schedule.pattern().debugInfo() + "]");
    }
}

