/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals;

import java.util.Collection;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.BestNumberOfTransfers;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.DestinationArrivalListener;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.AccessStopArrivalState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.DefaultStopArrivalState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.EgressStopArrivalState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.StopArrivalState;
import org.opentripplanner.transit.raptor.rangeraptor.transit.EgressPaths;

public final class StdStopArrivals<T extends RaptorTripSchedule>
implements BestNumberOfTransfers {
    private final StopArrivalState<T>[][] arrivals;
    private final RoundProvider roundProvider;

    public StdStopArrivals(int nRounds, int nStops, RoundProvider roundProvider) {
        this.roundProvider = roundProvider;
        this.arrivals = new StopArrivalState[nRounds][nStops];
    }

    public void setupEgressStopStates(EgressPaths egressPaths, DestinationArrivalListener destinationArrivalListener) {
        int i = 1;
        while (i < this.arrivals.length) {
            int round = i++;
            egressPaths.byStop().forEachEntry((stop, list) -> {
                this.arrivals[round][stop] = new EgressStopArrivalState(stop, round, (Collection<RaptorAccessEgress>)list, destinationArrivalListener);
                return true;
            });
        }
    }

    public StopArrivalState<T> get(int round, int stop) {
        return this.arrivals[round][stop];
    }

    @Override
    public int calculateMinNumberOfTransfers(int stop) {
        for (int i = 0; i < this.arrivals.length; ++i) {
            if (this.arrivals[i][stop] == null) continue;
            return i - 1;
        }
        return this.unreachedMinNumberOfTransfers();
    }

    void setAccessTime(int time, RaptorAccessEgress access, boolean bestTime) {
        int stop = access.stop();
        StopArrivalState<T> existingArrival = this.getOrCreateStopIndex(this.round(), stop);
        if (existingArrival instanceof AccessStopArrivalState) {
            ((AccessStopArrivalState)existingArrival).setAccessTime(time, access, bestTime);
        } else {
            this.arrivals[this.round()][stop] = new AccessStopArrivalState(time, access, bestTime, (DefaultStopArrivalState)existingArrival);
        }
    }

    void transferToStop(int fromStop, RaptorTransfer transfer, int arrivalTime) {
        int stop = transfer.stop();
        StopArrivalState<T> state = this.getOrCreateStopIndex(this.round(), stop);
        state.transferToStop(fromStop, arrivalTime, transfer);
    }

    void transitToStop(int stop, int time, int boardStop, int boardTime, T trip, boolean bestTime) {
        StopArrivalState<T> state = this.getOrCreateStopIndex(this.round(), stop);
        state.arriveByTransit(time, boardStop, boardTime, trip);
        if (bestTime) {
            state.setBestTimeTransit(time);
        }
    }

    int bestTimePreviousRound(int stop) {
        return this.get(this.round() - 1, stop).time();
    }

    TransitArrival<T> previousTransit(int boardStopIndex) {
        int prevRound = this.round() - 1;
        int stopIndex = boardStopIndex;
        StopArrivalState<T> state = this.get(prevRound, boardStopIndex);
        if (state.arrivedByTransfer()) {
            stopIndex = state.transferFromStop();
            state = this.arrivals[prevRound][stopIndex];
        }
        return state.arrivedByTransit() ? TransitArrival.create(state.trip(), stopIndex, state.onBoardArrivalTime()) : null;
    }

    private int round() {
        return this.roundProvider.round();
    }

    private StopArrivalState<T> getOrCreateStopIndex(int round, int stop) {
        if (this.arrivals[round][stop] == null) {
            this.arrivals[round][stop] = StopArrivalState.create();
        }
        return this.get(round, stop);
    }
}

