/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.configure;

import java.util.function.BiFunction;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.HeuristicSearch;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Worker;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.path.configure.PathConfig;
import org.opentripplanner.transit.raptor.rangeraptor.standard.ArrivalTimeRoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.standard.MinTravelDurationRoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.standard.StdRangeRaptorWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.BestTimesOnlyStopArrivalsState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.SimpleArrivedAtDestinationCheck;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.SimpleBestNumberOfTransfers;
import org.opentripplanner.transit.raptor.rangeraptor.standard.configure.VerifyRequestIsValid;
import org.opentripplanner.transit.raptor.rangeraptor.standard.debug.DebugStopArrivalsState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.heuristics.HeuristicsAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.ArrivedAtDestinationCheck;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.BestNumberOfTransfers;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.StopArrivalsState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.StdStopArrivals;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.StdStopArrivalsState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.path.EgressArrivalToPathAdapter;
import org.opentripplanner.transit.raptor.rangeraptor.standard.stoparrivals.view.StopsCursor;

public class StdRangeRaptorConfig<T extends RaptorTripSchedule> {
    private final SearchContext<T> ctx;
    private final PathConfig<T> pathConfig;
    private BestTimes bestTimes = null;
    private StdStopArrivals<T> arrivals = null;
    private ArrivedAtDestinationCheck destinationCheck = null;
    private BestNumberOfTransfers bestNumberOfTransfers = null;

    public StdRangeRaptorConfig(SearchContext<T> context) {
        this.ctx = context;
        this.pathConfig = new PathConfig<T>(context);
    }

    public HeuristicSearch<T> createHeuristicSearch(BiFunction<WorkerState<T>, RoutingStrategy<T>, Worker<T>> createWorker, CostCalculator<T> costCalculator) {
        StdRangeRaptorWorkerState<T> state = this.createState();
        Heuristics heuristics = this.createHeuristicsAdapter(costCalculator);
        return new HeuristicSearch<T>(createWorker.apply(state, this.createWorkerStrategy(state)), heuristics);
    }

    public Worker<T> createSearch(BiFunction<WorkerState<T>, RoutingStrategy<T>, Worker<T>> createWorker) {
        StdRangeRaptorWorkerState<T> state = this.createState();
        return createWorker.apply(state, this.createWorkerStrategy(state));
    }

    private StdRangeRaptorWorkerState<T> createState() {
        new VerifyRequestIsValid(this.ctx).verify();
        switch (this.ctx.profile()) {
            case STANDARD: 
            case MIN_TRAVEL_DURATION: {
                return this.workerState(this.stdStopArrivalsState());
            }
            case BEST_TIME: 
            case MIN_TRAVEL_DURATION_BEST_TIME: {
                return this.workerState(this.bestTimeStopArrivalsState());
            }
        }
        throw new IllegalArgumentException(this.ctx.profile().toString());
    }

    private RoutingStrategy<T> createWorkerStrategy(StdWorkerState<T> state) {
        switch (this.ctx.profile()) {
            case STANDARD: 
            case BEST_TIME: {
                return new ArrivalTimeRoutingStrategy<T>(this.ctx.calculator(), state);
            }
            case MIN_TRAVEL_DURATION: 
            case MIN_TRAVEL_DURATION_BEST_TIME: {
                return new MinTravelDurationRoutingStrategy<T>(this.ctx.calculator(), state);
            }
        }
        throw new IllegalArgumentException(this.ctx.profile().toString());
    }

    private Heuristics createHeuristicsAdapter(CostCalculator<T> costCalculator) {
        this.assertNotNull(this.bestNumberOfTransfers);
        return new HeuristicsAdapter(this.bestTimes(), this.bestNumberOfTransfers, this.ctx.egressPaths(), this.ctx.calculator(), costCalculator, this.ctx.lifeCycle());
    }

    private StdRangeRaptorWorkerState<T> workerState(StopArrivalsState<T> stopArrivalsState) {
        return new StdRangeRaptorWorkerState<T>(this.ctx.calculator(), this.bestTimes(), stopArrivalsState, this.destinationCheck());
    }

    private BestTimesOnlyStopArrivalsState<T> bestTimeStopArrivalsState() {
        return new BestTimesOnlyStopArrivalsState(this.bestTimes(), this.simpleBestNumberOfTransfers());
    }

    private SimpleBestNumberOfTransfers simpleBestNumberOfTransfers() {
        SimpleBestNumberOfTransfers value = new SimpleBestNumberOfTransfers(this.ctx.nStops(), this.ctx.roundProvider());
        this.setBestNumberOfTransfers(value);
        return value;
    }

    private StopArrivalsState<T> stdStopArrivalsState() {
        StdStopArrivalsState<T> state = new StdStopArrivalsState<T>(this.stopArrivals(), this.destinationArrivalPaths());
        return this.wrapStopArrivalsStateWithDebugger(state);
    }

    private StopArrivalsState<T> wrapStopArrivalsStateWithDebugger(StopArrivalsState<T> state) {
        if (this.ctx.debugFactory().isDebugStopArrival()) {
            return new DebugStopArrivalsState<T>(this.ctx.roundProvider(), this.ctx.debugFactory(), this.stopsCursor(), state);
        }
        return state;
    }

    private StdStopArrivals<T> stopArrivals() {
        if (this.arrivals == null) {
            this.arrivals = new StdStopArrivals(this.ctx.nRounds(), this.ctx.nStops(), this.ctx.roundProvider());
            this.setBestNumberOfTransfers(this.arrivals);
        }
        return this.arrivals;
    }

    private void setBestNumberOfTransfers(BestNumberOfTransfers bestNumberOfTransfers) {
        this.assertSetValueIsNull("bestNumberOfTransfers", this.bestNumberOfTransfers, bestNumberOfTransfers);
        this.bestNumberOfTransfers = bestNumberOfTransfers;
    }

    private StopsCursor<T> stopsCursor() {
        return new StopsCursor<T>(this.stopArrivals(), this.ctx.calculator(), this.ctx.boardSlackProvider());
    }

    private DestinationArrivalPaths<T> destinationArrivalPaths() {
        DestinationArrivalPaths<T> destinationArrivalPaths = this.pathConfig.createDestArrivalPaths(false);
        EgressArrivalToPathAdapter<T> pathsAdapter = new EgressArrivalToPathAdapter<T>(destinationArrivalPaths, this.ctx.calculator(), this.stopsCursor(), this.ctx.lifeCycle());
        this.setDestinationCheck(pathsAdapter);
        this.stopArrivals().setupEgressStopStates(this.ctx.egressPaths(), pathsAdapter);
        return destinationArrivalPaths;
    }

    private BestTimes bestTimes() {
        if (this.bestTimes == null) {
            this.bestTimes = new BestTimes(this.ctx.nStops(), this.ctx.calculator(), this.ctx.lifeCycle());
        }
        return this.bestTimes;
    }

    private ArrivedAtDestinationCheck destinationCheck() {
        if (this.destinationCheck == null) {
            this.setDestinationCheck(this.simpleDestinationCheck());
        }
        return this.destinationCheck;
    }

    private void setDestinationCheck(ArrivedAtDestinationCheck check) {
        if (this.destinationCheck != null) {
            throw new IllegalStateException("ArrivedAtDestinationCheck is alredy initialized: " + this.destinationCheck.getClass().getSimpleName());
        }
        this.destinationCheck = check;
    }

    private SimpleArrivedAtDestinationCheck simpleDestinationCheck() {
        return new SimpleArrivedAtDestinationCheck(this.ctx.egressStops(), this.bestTimes());
    }

    private void assertSetValueIsNull(String name, Object setValue, Object newValue) {
        if (setValue != null) {
            throw new IllegalStateException("There is more than one instance of " + name + ": " + newValue.getClass().getSimpleName() + ", " + setValue.getClass().getSimpleName());
        }
    }

    private void assertNotNull(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
    }
}

