/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes;

import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.BestNumberOfTransfers;
import org.opentripplanner.util.lang.IntUtils;

public class SimpleBestNumberOfTransfers
implements BestNumberOfTransfers {
    private final int[] bestNumOfTransfers;
    private final RoundProvider roundProvider;

    public SimpleBestNumberOfTransfers(int nStops, RoundProvider roundProvider) {
        this.bestNumOfTransfers = IntUtils.intArray(nStops, this.unreachedMinNumberOfTransfers());
        this.roundProvider = roundProvider;
    }

    @Override
    public int calculateMinNumberOfTransfers(int stop) {
        return this.bestNumOfTransfers[stop];
    }

    void arriveAtStop(int stop) {
        int numOfTransfers = this.roundProvider.round() - 1;
        if (numOfTransfers < this.bestNumOfTransfers[stop]) {
            this.bestNumOfTransfers[stop] = numOfTransfers;
        }
    }
}

