/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes;

import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.SimpleBestNumberOfTransfers;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.StopArrivalsState;

public class BestTimesOnlyStopArrivalsState<T extends RaptorTripSchedule>
implements StopArrivalsState<T> {
    private final BestTimes bestTimes;
    private final SimpleBestNumberOfTransfers bestNumberOfTransfers;

    public BestTimesOnlyStopArrivalsState(BestTimes bestTimes, SimpleBestNumberOfTransfers bestNumberOfTransfers) {
        this.bestTimes = bestTimes;
        this.bestNumberOfTransfers = bestNumberOfTransfers;
    }

    @Override
    public void setAccessTime(int arrivalTime, RaptorAccessEgress access, boolean bestTime) {
        this.bestNumberOfTransfers.arriveAtStop(access.stop());
    }

    @Override
    public int bestTimePreviousRound(int stop) {
        return this.bestTimes.time(stop);
    }

    @Override
    public void setNewBestTransitTime(int stop, int alightTime, T trip, int boardStop, int boardTime, boolean newBestOverall) {
        this.bestNumberOfTransfers.arriveAtStop(stop);
    }

    @Override
    public void setNewBestTransferTime(int fromStop, int arrivalTime, RaptorTransfer transfer) {
        this.bestNumberOfTransfers.arriveAtStop(transfer.stop());
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        throw new IllegalStateException("The implementation of this interface is not compatible with the requestconfiguration. For example the BestTimesOnlyStopArrivalsState can not be used with constrained transfers.");
    }

    @Override
    public int calculateMinNumberOfTransfers(int stopIndex) {
        return this.bestNumberOfTransfers.calculateMinNumberOfTransfers(stopIndex);
    }
}

