/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes;

import java.util.BitSet;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.transit.raptor.util.BitSetIterator;
import org.opentripplanner.util.lang.IntUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public final class BestTimes {
    private final int[] times;
    private final int[] transitArrivalTimes;
    private final BitSet reachedByTransitCurrentRound;
    private final TransitCalculator<?> calculator;
    private BitSet reachedCurrentRound;
    private BitSet reachedLastRound;

    public BestTimes(int nStops, TransitCalculator<?> calculator, WorkerLifeCycle lifeCycle) {
        this.calculator = calculator;
        this.times = IntUtils.intArray(nStops, calculator.unreachedTime());
        this.reachedCurrentRound = new BitSet(nStops);
        this.reachedLastRound = new BitSet(nStops);
        this.transitArrivalTimes = IntUtils.intArray(nStops, calculator.unreachedTime());
        this.reachedByTransitCurrentRound = new BitSet(nStops);
        lifeCycle.onSetupIteration(ignore -> this.setupIteration());
        lifeCycle.onPrepareForNextRound(round -> this.prepareForNextRound());
    }

    public int time(int stop) {
        return this.times[stop];
    }

    public int transitArrivalTime(int stop) {
        return this.transitArrivalTimes[stop];
    }

    public boolean isCurrentRoundUpdated() {
        return !this.reachedCurrentRound.isEmpty();
    }

    public BitSetIterator stopsReachedLastRound() {
        return new BitSetIterator(this.reachedLastRound);
    }

    public BitSetIterator reachedByTransitCurrentRound() {
        return new BitSetIterator(this.reachedByTransitCurrentRound);
    }

    public boolean isStopReachedLastRound(int stop) {
        return this.reachedLastRound.get(stop);
    }

    public boolean isStopReached(int stop) {
        return this.time(stop) != this.calculator.unreachedTime();
    }

    public boolean isStopReachedByTransit(int stop) {
        return this.transitArrivalTime(stop) != this.calculator.unreachedTime();
    }

    public boolean updateBestTransitArrivalTime(int stop, int time) {
        if (this.isBestTransitArrivalTime(stop, time)) {
            this.setBestTime(stop, time);
            return true;
        }
        return false;
    }

    public boolean updateNewBestTime(int stop, int time) {
        if (this.isBestTime(stop, time)) {
            this.setTime(stop, time);
            return true;
        }
        return false;
    }

    public int size() {
        return this.times.length;
    }

    public String toString() {
        int unreachedTime = this.calculator.unreachedTime();
        return ToStringBuilder.of(BestTimes.class).addIntArraySize("times", this.times, unreachedTime).addIntArraySize("transitArrivalTimes", this.transitArrivalTimes, unreachedTime).addNum("reachedCurrentRound", this.reachedCurrentRound.size()).addBitSetSize("reachedByTransitCurrentRound", this.reachedByTransitCurrentRound).addBitSetSize("reachedLastRound", this.reachedLastRound).toString();
    }

    boolean isStopReachedOnBoardInCurrentRound(int stop) {
        return this.reachedByTransitCurrentRound.get(stop);
    }

    private void setupIteration() {
        this.reachedCurrentRound.clear();
        this.reachedByTransitCurrentRound.clear();
    }

    private void prepareForNextRound() {
        this.swapReachedCurrentAndLastRound();
        this.reachedCurrentRound.clear();
        this.reachedByTransitCurrentRound.clear();
    }

    private void setTime(int stop, int time) {
        this.times[stop] = time;
        this.reachedCurrentRound.set(stop);
    }

    private boolean isBestTime(int stop, int time) {
        return this.calculator.isBefore(time, this.times[stop]);
    }

    private boolean isBestTransitArrivalTime(int stop, int time) {
        return this.calculator.isBefore(time, this.transitArrivalTimes[stop]);
    }

    private void setBestTime(int stop, int time) {
        this.transitArrivalTimes[stop] = time;
        this.reachedByTransitCurrentRound.set(stop);
    }

    private void swapReachedCurrentAndLastRound() {
        BitSet tmp = this.reachedLastRound;
        this.reachedLastRound = this.reachedCurrentRound;
        this.reachedCurrentRound = tmp;
    }
}

