/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard;

import java.util.Collection;
import java.util.Iterator;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.response.StopArrivals;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.transit.raptor.rangeraptor.standard.besttimes.StopArrivalsAdaptor;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.ArrivedAtDestinationCheck;
import org.opentripplanner.transit.raptor.rangeraptor.standard.internalapi.StopArrivalsState;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.transit.raptor.util.BitSetIterator;

public final class StdRangeRaptorWorkerState<T extends RaptorTripSchedule>
implements StdWorkerState<T> {
    private final BestTimes bestTimes;
    private final StopArrivalsState<T> stopArrivalsState;
    private final ArrivedAtDestinationCheck arrivedAtDestinationCheck;
    private final TransitCalculator<T> calculator;

    public StdRangeRaptorWorkerState(TransitCalculator<T> calculator, BestTimes bestTimes, StopArrivalsState<T> stopArrivalsState, ArrivedAtDestinationCheck arrivedAtDestinationCheck) {
        this.calculator = calculator;
        this.bestTimes = bestTimes;
        this.stopArrivalsState = stopArrivalsState;
        this.arrivedAtDestinationCheck = arrivedAtDestinationCheck;
    }

    @Override
    public boolean isNewRoundAvailable() {
        return this.bestTimes.isCurrentRoundUpdated();
    }

    @Override
    public IntIterator stopsTouchedPreviousRound() {
        return this.bestTimes.stopsReachedLastRound();
    }

    @Override
    public BitSetIterator stopsTouchedByTransitCurrentRound() {
        return this.bestTimes.reachedByTransitCurrentRound();
    }

    @Override
    public boolean isDestinationReachedInCurrentRound() {
        return this.arrivedAtDestinationCheck.arrivedAtDestinationCurrentRound();
    }

    @Override
    public void setAccessToStop(RaptorAccessEgress accessPath, int departureTime) {
        int durationInSeconds = accessPath.durationInSeconds();
        int stop = accessPath.stop();
        int arrivalTime = this.calculator.plusDuration(departureTime, durationInSeconds);
        if (this.exceedsTimeLimit(arrivalTime)) {
            return;
        }
        boolean reachedOnBoard = accessPath.stopReachedOnBoard() && this.newBestTransitArrivalTime(stop, arrivalTime);
        boolean bestTime = this.newOverallBestTime(stop, arrivalTime);
        if (reachedOnBoard || bestTime) {
            this.stopArrivalsState.setAccessTime(arrivalTime, accessPath, bestTime);
        } else {
            this.stopArrivalsState.rejectAccessTime(arrivalTime, accessPath);
        }
    }

    @Override
    public void transferToStops(int fromStop, Iterator<? extends RaptorTransfer> transfers) {
        int arrivalTimeTransit = this.bestTimes.transitArrivalTime(fromStop);
        while (transfers.hasNext()) {
            this.transferToStop(arrivalTimeTransit, fromStop, transfers.next());
        }
    }

    @Override
    public Collection<Path<T>> extractPaths() {
        return this.stopArrivalsState.extractPaths();
    }

    @Override
    public boolean isStopReachedInPreviousRound(int stop) {
        return this.bestTimes.isStopReachedLastRound(stop);
    }

    @Override
    public int bestTimePreviousRound(int stop) {
        return this.stopArrivalsState.bestTimePreviousRound(stop);
    }

    @Override
    public void transitToStop(int stop, int arrivalTime, int boardStop, int boardTime, T trip) {
        if (this.exceedsTimeLimit(arrivalTime)) {
            return;
        }
        if (this.newBestTransitArrivalTime(stop, arrivalTime)) {
            boolean newOverallBestTime = this.newOverallBestTime(stop, arrivalTime);
            this.stopArrivalsState.setNewBestTransitTime(stop, arrivalTime, trip, boardStop, boardTime, newOverallBestTime);
        } else {
            this.stopArrivalsState.rejectNewBestTransitTime(stop, arrivalTime, trip, boardStop, boardTime);
        }
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        return this.stopArrivalsState.previousTransit(boardStopIndex);
    }

    @Override
    public StopArrivals extractStopArrivals() {
        return new StopArrivalsAdaptor(this.bestTimes, this.stopArrivalsState);
    }

    private void transferToStop(int arrivalTimeTransit, int fromStop, RaptorTransfer transfer) {
        int arrivalTime = this.calculator.plusDuration(arrivalTimeTransit, transfer.durationInSeconds());
        if (this.exceedsTimeLimit(arrivalTime)) {
            return;
        }
        int toStop = transfer.stop();
        if (this.newOverallBestTime(toStop, arrivalTime)) {
            this.stopArrivalsState.setNewBestTransferTime(fromStop, arrivalTime, transfer);
        } else {
            this.stopArrivalsState.rejectNewBestTransferTime(fromStop, arrivalTime, transfer);
        }
    }

    private boolean newOverallBestTime(int stop, int alightTime) {
        return this.bestTimes.updateNewBestTime(stop, alightTime);
    }

    private boolean newBestTransitArrivalTime(int stop, int alightTime) {
        return this.bestTimes.updateBestTransitArrivalTime(stop, alightTime);
    }

    private boolean exceedsTimeLimit(int time) {
        return this.calculator.exceedsTimeLimit(time);
    }
}

