/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.standard;

import java.util.function.IntConsumer;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleBoardOrAlightEvent;
import org.opentripplanner.transit.raptor.api.transit.TransitArrival;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.transit.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.transit.raptor.rangeraptor.transit.TransitCalculator;

public final class ArrivalTimeRoutingStrategy<T extends RaptorTripSchedule>
implements RoutingStrategy<T> {
    private static final int NOT_SET = -1;
    private final TransitCalculator<T> calculator;
    private final StdWorkerState<T> state;
    private int onTripIndex;
    private int onTripBoardTime;
    private int onTripBoardStop;
    private T onTrip;

    public ArrivalTimeRoutingStrategy(TransitCalculator<T> calculator, StdWorkerState<T> state) {
        this.calculator = calculator;
        this.state = state;
    }

    @Override
    public void setAccessToStop(RaptorAccessEgress accessPath, int iterationDepartureTime, int timeDependentDepartureTime) {
        this.state.setAccessToStop(accessPath, timeDependentDepartureTime);
    }

    @Override
    public void prepareForTransitWith() {
        this.onTripIndex = -1;
        this.onTripBoardTime = -1;
        this.onTripBoardStop = -1;
        this.onTrip = null;
    }

    @Override
    public void alight(int stopIndex, int stopPos, int alightSlack) {
        if (this.onTripIndex != -1) {
            int stopArrivalTime = this.calculator.stopArrivalTime(this.onTrip, stopPos, alightSlack);
            this.state.transitToStop(stopIndex, stopArrivalTime, this.onTripBoardStop, this.onTripBoardTime, this.onTrip);
        }
    }

    @Override
    public void forEachBoarding(int stopIndex, IntConsumer prevStopArrivalTimeConsumer) {
        if (this.state.isStopReachedInPreviousRound(stopIndex)) {
            prevStopArrivalTimeConsumer.accept(this.state.bestTimePreviousRound(stopIndex));
        }
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        return this.state.previousTransit(boardStopIndex);
    }

    @Override
    public void board(int stopIndex, int earliestBoardTime, RaptorTripScheduleBoardOrAlightEvent<T> boarding) {
        this.onTripIndex = boarding.getTripIndex();
        this.onTrip = boarding.getTrip();
        this.onTripBoardTime = boarding.getTime();
        this.onTripBoardStop = stopIndex;
    }

    @Override
    public int onTripIndex() {
        return this.onTripIndex;
    }
}

