/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.path.configure;

import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorSlackProvider;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;
import org.opentripplanner.transit.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.transit.raptor.rangeraptor.path.ForwardPathMapper;
import org.opentripplanner.transit.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.transit.raptor.rangeraptor.path.PathParetoSetComparators;
import org.opentripplanner.transit.raptor.rangeraptor.path.ReversePathMapper;
import org.opentripplanner.transit.raptor.util.paretoset.ParetoComparator;

public class PathConfig<T extends RaptorTripSchedule> {
    private final SearchContext<T> ctx;

    public PathConfig(SearchContext<T> context) {
        this.ctx = context;
    }

    public DestinationArrivalPaths<T> createDestArrivalPaths(boolean includeCost) {
        return new DestinationArrivalPaths<T>(this.paretoComparator(includeCost), this.ctx.calculator(), this.ctx.costCalculator(), this.ctx.slackProvider(), this.createPathMapper(), this.ctx.debugFactory(), this.ctx.stopNameResolver(), this.ctx.lifeCycle());
    }

    private ParetoComparator<Path<T>> paretoComparator(boolean includeCost) {
        double relaxedCost = this.ctx.searchParams().relaxCostAtDestination();
        boolean includeRelaxedCost = includeCost && relaxedCost > 0.0;
        boolean includeTimetable = this.ctx.searchParams().timetableEnabled();
        boolean preferLateArrival = this.ctx.searchParams().preferLateArrival();
        if (includeTimetable && includeRelaxedCost) {
            return PathParetoSetComparators.comparatorWithTimetableAndRelaxedCost(relaxedCost);
        }
        if (includeTimetable && includeCost) {
            return PathParetoSetComparators.comparatorWithTimetableAndCost();
        }
        if (includeTimetable) {
            return PathParetoSetComparators.comparatorWithTimetable();
        }
        if (includeRelaxedCost && preferLateArrival) {
            return PathParetoSetComparators.comparatorWithRelaxedCostAndLatestDeparture(relaxedCost);
        }
        if (includeRelaxedCost) {
            return PathParetoSetComparators.comparatorWithRelaxedCost(relaxedCost);
        }
        if (includeCost && preferLateArrival) {
            return PathParetoSetComparators.comparatorWithCostAndLatestDeparture();
        }
        if (includeCost) {
            return PathParetoSetComparators.comparatorWithCost();
        }
        if (preferLateArrival) {
            return PathParetoSetComparators.comparatorStandardAndLatestDepature();
        }
        return PathParetoSetComparators.comparatorStandard();
    }

    private PathMapper<T> createPathMapper() {
        return PathConfig.createPathMapper(this.ctx.transit().transferConstraintsSearch(), this.ctx.costCalculator(), this.ctx.stopNameResolver(), this.ctx.lifeCycle(), this.ctx.searchDirection(), this.ctx.profile(), this.ctx.raptorSlackProvider());
    }

    private static <S extends RaptorTripSchedule> PathMapper<S> createPathMapper(RaptorPathConstrainedTransferSearch<S> txConstraintsSearch, CostCalculator<S> costCalculator, RaptorStopNameResolver stopNameResolver, WorkerLifeCycle lifeCycle, SearchDirection searchDirection, RaptorProfile profile, RaptorSlackProvider slackProvider) {
        return searchDirection.isForward() ? new ForwardPathMapper<S>(txConstraintsSearch, slackProvider, costCalculator, stopNameResolver, lifeCycle, profile.useApproximateTripSearch()) : new ReversePathMapper<S>(txConstraintsSearch, slackProvider, costCalculator, stopNameResolver, lifeCycle, profile.useApproximateTripSearch());
    }
}

