/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.path;

import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.api.view.EgressPathView;

public class DestinationArrival<T extends RaptorTripSchedule>
implements ArrivalView<T> {
    private final ArrivalView<T> previous;
    private final RaptorAccessEgress egress;
    private final int arrivalTime;
    private final int numberOfTransfers;
    private final int cost;

    public DestinationArrival(RaptorAccessEgress egress, ArrivalView<T> previous, int arrivalTime, int additionalCost) {
        this.previous = previous;
        this.egress = egress;
        this.arrivalTime = arrivalTime;
        this.numberOfTransfers = previous.round() - 1;
        this.cost = previous.cost() + additionalCost;
    }

    @Override
    public int stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int round() {
        return 1 + this.numberOfTransfers + this.egress.numberOfRides();
    }

    @Override
    public int arrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public int cost() {
        return this.cost;
    }

    @Override
    public ArrivalView<T> previous() {
        return this.previous;
    }

    @Override
    public boolean arrivedAtDestination() {
        return true;
    }

    @Override
    public EgressPathView egressPath() {
        return () -> this.egress;
    }

    public String toString() {
        return this.asString();
    }
}

