/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria.heuristic;

import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.HeuristicAtStop;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;
import org.opentripplanner.transit.raptor.rangeraptor.path.DestinationArrivalPaths;

public final class HeuristicsProvider<T extends RaptorTripSchedule> {
    private final Heuristics heuristics;
    private final RoundProvider roundProvider;
    private final DestinationArrivalPaths<T> paths;
    private final HeuristicAtStop[] stops;
    private final DebugHandlerFactory<T> debugHandlerFactory;

    public HeuristicsProvider() {
        this(null, null, null, null);
    }

    public HeuristicsProvider(Heuristics heuristics, RoundProvider roundProvider, DestinationArrivalPaths<T> paths, DebugHandlerFactory<T> debugHandlerFactory) {
        this.heuristics = heuristics;
        this.roundProvider = roundProvider;
        this.paths = paths;
        this.stops = heuristics == null ? null : new HeuristicAtStop[heuristics.size()];
        this.debugHandlerFactory = debugHandlerFactory;
    }

    public boolean rejectDestinationArrivalBasedOnHeuristic(AbstractStopArrival<T> arrival) {
        boolean rejected;
        if (this.heuristics == null || this.paths.isEmpty()) {
            return false;
        }
        boolean bl = rejected = !this.qualify(arrival.stop(), arrival.arrivalTime(), arrival.travelDuration(), arrival.cost());
        if (rejected) {
            this.debugRejectByOptimization(arrival);
        }
        return rejected;
    }

    private void debugRejectByOptimization(AbstractStopArrival<T> arrival) {
        if (this.debugHandlerFactory.isDebugStopArrival(arrival.stop())) {
            String details = this.rejectErrorMessage(arrival.stop()) + ", Existing paths: " + this.paths;
            this.debugHandlerFactory.debugStopArrival().reject(arrival, null, "The element is rejected because the destination is not reachable within the limit based on heuristic. Details: " + details);
        }
    }

    private boolean qualify(int stop, int arrivalTime, int travelDuration, int cost) {
        HeuristicAtStop h = this.get(stop);
        if (h == null) {
            return false;
        }
        int minArrivalTime = arrivalTime + h.minTravelDuration();
        int minNumberOfTransfers = this.roundProvider.round() - 1 + h.minNumTransfers();
        int minTravelDuration = travelDuration + h.minTravelDuration();
        int minCost = cost + h.minCost();
        int departureTime = minArrivalTime - minTravelDuration;
        return this.paths.qualify(departureTime, minArrivalTime, minNumberOfTransfers, minCost);
    }

    private String rejectErrorMessage(int stop) {
        return this.get(stop) == null ? "The stop was not reached in the heuristic calculation." : this.get(stop).toString();
    }

    private HeuristicAtStop get(int stop) {
        if (this.stops[stop] == null && this.heuristics.reached(stop)) {
            this.stops[stop] = this.heuristics.createHeuristicAtStop(stop);
        }
        return this.stops[stop];
    }
}

