/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals;

import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.api.view.AccessPathView;
import org.opentripplanner.transit.raptor.rangeraptor.multicriteria.arrivals.AbstractStopArrival;

public final class AccessStopArrival<T extends RaptorTripSchedule>
extends AbstractStopArrival<T> {
    private final RaptorAccessEgress access;

    public AccessStopArrival(int departureTime, RaptorAccessEgress access) {
        super(access.stop(), departureTime, access.durationInSeconds(), access.generalizedCost(), access.numberOfRides());
        this.access = access;
    }

    @Override
    public boolean arrivedByAccess() {
        return true;
    }

    @Override
    public AccessPathView accessPath() {
        return () -> this.access;
    }

    @Override
    public AbstractStopArrival<T> timeShiftNewArrivalTime(int newRequestedArrivalTime) {
        int newArrivalTime = this.access.latestArrivalTime(newRequestedArrivalTime);
        if (newArrivalTime == -1 || newArrivalTime == this.arrivalTime()) {
            return this;
        }
        int newDepartureTime = newArrivalTime - this.access.durationInSeconds();
        return new AccessStopArrival<T>(newDepartureTime, this.access);
    }
}

