/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.rangeraptor.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.opentripplanner.transit.raptor.rangeraptor.internalapi.WorkerLifeCycle;

public final class LifeCycleSubscriptions
implements WorkerLifeCycle {
    final List<Consumer<Boolean>> onRouteSearchListeners = new ArrayList<Consumer<Boolean>>();
    final List<IntConsumer> setupIterationListeners = new ArrayList<IntConsumer>();
    final List<IntConsumer> prepareForNextRoundListeners = new ArrayList<IntConsumer>();
    final List<Runnable> transitsForRoundCompleteListeners = new ArrayList<Runnable>();
    final List<Runnable> transfersForRoundCompleteListeners = new ArrayList<Runnable>();
    final List<Consumer<Boolean>> roundCompleteListeners = new ArrayList<Consumer<Boolean>>();
    final List<Runnable> iterationCompleteListeners = new ArrayList<Runnable>();
    private boolean openForSubscription = true;

    @Override
    public void onRouteSearch(Consumer<Boolean> routeSearchWithDirectionSubscriber) {
        this.subscribe(this.onRouteSearchListeners, routeSearchWithDirectionSubscriber);
    }

    @Override
    public void onSetupIteration(IntConsumer setupIterationWithDepartureTime) {
        this.subscribe(this.setupIterationListeners, setupIterationWithDepartureTime);
    }

    @Override
    public void onPrepareForNextRound(IntConsumer prepareForNextRound) {
        this.subscribe(this.prepareForNextRoundListeners, prepareForNextRound);
    }

    @Override
    public void onTransitsForRoundComplete(Runnable transitsForRoundComplete) {
        this.subscribe(this.transitsForRoundCompleteListeners, transitsForRoundComplete);
    }

    @Override
    public void onTransfersForRoundComplete(Runnable transfersForRoundComplete) {
        this.subscribe(this.transfersForRoundCompleteListeners, transfersForRoundComplete);
    }

    @Override
    public void onRoundComplete(Consumer<Boolean> roundCompleteWithDestinationReached) {
        this.subscribe(this.roundCompleteListeners, roundCompleteWithDestinationReached);
    }

    @Override
    public void onIterationComplete(Runnable iterationComplete) {
        this.subscribe(this.iterationCompleteListeners, iterationComplete);
    }

    public void close() {
        this.openForSubscription = false;
    }

    private <T> void subscribe(List<T> subscriptions, T subscriber) {
        this.assertIsOpen();
        if (subscriber != null) {
            subscriptions.add(subscriber);
        }
    }

    private void assertIsOpen() {
        if (!this.openForSubscription) {
            throw new IllegalStateException("Unable to subscribe, publisher already created.");
        }
    }
}

