/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.transit;

public interface RaptorSlackProvider {
    public static RaptorSlackProvider defaultSlackProvider(final int transferSlack, final int boardSlack, final int alightSlack) {
        return new RaptorSlackProvider(){

            @Override
            public int transferSlack() {
                return transferSlack;
            }

            @Override
            public int boardSlack(int slackIndex) {
                return boardSlack;
            }

            @Override
            public int alightSlack(int slackIndex) {
                return alightSlack;
            }
        };
    }

    public int transferSlack();

    public int boardSlack(int var1);

    public int alightSlack(int var1);

    default public int transitSlack(int slackIndex) {
        return this.boardSlack(slackIndex) + this.alightSlack(slackIndex);
    }

    default public int calcRegularTransferDuration(int transferDurationInSeconds, int fromTripAlightSlackIndex, int toTripBoardSlackIndex) {
        return this.alightSlack(fromTripAlightSlackIndex) + transferDurationInSeconds + this.transferSlack() + this.boardSlack(toTripBoardSlackIndex);
    }
}

