/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.transit;

import java.util.Objects;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.util.lang.ValueObjectToStringBuilder;

public class BoardAndAlightTime {
    private final RaptorTripSchedule trip;
    private final int boardStopPos;
    private final int alightStopPos;

    public BoardAndAlightTime(RaptorTripSchedule trip, int boardStopPos, int alightStopPos) {
        this.trip = trip;
        this.boardStopPos = boardStopPos;
        this.alightStopPos = alightStopPos;
    }

    public static BoardAndAlightTime create(RaptorTripSchedule trip, int boardStop, int boardTime, int alightStop, int alightTime) {
        return new BoardAndAlightTime(trip, trip.findDepartureStopPosition(boardTime, boardStop), trip.findArrivalStopPosition(alightTime, alightStop));
    }

    public int boardTime() {
        return this.trip.departure(this.boardStopPos);
    }

    public int alightTime() {
        return this.trip.arrival(this.alightStopPos);
    }

    public int boardStopPos() {
        return this.boardStopPos;
    }

    public int alightStopPos() {
        return this.alightStopPos;
    }

    public int hashCode() {
        return Objects.hash(this.boardStopPos, this.alightStopPos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoardAndAlightTime that = (BoardAndAlightTime)o;
        return this.boardStopPos == that.boardStopPos && this.alightStopPos == that.alightStopPos;
    }

    public String toString() {
        return ValueObjectToStringBuilder.of().addText("[").addObj(this.trip.pattern().stopIndex(this.boardStopPos)).addText(" ~ ").addServiceTime(this.boardTime()).addText(" ").addServiceTime(this.alightTime()).addText("(").addDurationSec(this.alightTime() - this.boardTime()).addText(") ~ ").addObj(this.trip.pattern().stopIndex(this.alightStopPos)).addText("]").toString();
    }
}

