/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.SearchParams;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.util.lang.ToStringBuilder;

public class SearchParamsBuilder<T extends RaptorTripSchedule> {
    private final RaptorRequestBuilder<T> parent;
    private final Collection<RaptorAccessEgress> accessPaths = new ArrayList<RaptorAccessEgress>();
    private final Collection<RaptorAccessEgress> egressPaths = new ArrayList<RaptorAccessEgress>();
    private int earliestDepartureTime;
    private int latestArrivalTime;
    private int searchWindowInSeconds;
    private boolean preferLateArrival;
    private int numberOfAdditionalTransfers;
    private int maxNumberOfTransfers;
    private double relaxCostAtDestination;
    private boolean timetableEnabled;
    private boolean constrainedTransfersEnabled;
    private boolean allowEmptyEgressPaths;

    public SearchParamsBuilder(RaptorRequestBuilder<T> parent, SearchParams defaults) {
        this.parent = parent;
        this.earliestDepartureTime = defaults.earliestDepartureTime();
        this.latestArrivalTime = defaults.latestArrivalTime();
        this.searchWindowInSeconds = defaults.searchWindowInSeconds();
        this.preferLateArrival = defaults.preferLateArrival();
        this.numberOfAdditionalTransfers = defaults.numberOfAdditionalTransfers();
        this.maxNumberOfTransfers = defaults.maxNumberOfTransfers();
        this.relaxCostAtDestination = defaults.relaxCostAtDestination();
        this.timetableEnabled = defaults.timetableEnabled();
        this.constrainedTransfersEnabled = defaults.constrainedTransfersEnabled();
        this.accessPaths.addAll(defaults.accessPaths());
        this.egressPaths.addAll(defaults.egressPaths());
        this.allowEmptyEgressPaths = defaults.allowEmptyEgressPaths();
    }

    public int earliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public SearchParamsBuilder<T> earliestDepartureTime(int earliestDepartureTime) {
        this.earliestDepartureTime = earliestDepartureTime;
        return this;
    }

    public int latestArrivalTime() {
        return this.latestArrivalTime;
    }

    public SearchParamsBuilder<T> latestArrivalTime(int latestArrivalTime) {
        this.latestArrivalTime = latestArrivalTime;
        return this;
    }

    public int searchWindowInSeconds() {
        return this.searchWindowInSeconds;
    }

    public SearchParamsBuilder<T> searchWindowInSeconds(int searchWindowInSeconds) {
        this.searchWindowInSeconds = searchWindowInSeconds;
        return this;
    }

    public SearchParamsBuilder<T> searchWindow(Duration searchWindow) {
        this.searchWindowInSeconds = searchWindow == null ? -1 : (int)searchWindow.toSeconds();
        return this;
    }

    public SearchParamsBuilder<T> searchOneIterationOnly() {
        return this.searchWindowInSeconds(0);
    }

    public boolean preferLateArrival() {
        return this.preferLateArrival;
    }

    public SearchParamsBuilder<T> preferLateArrival(boolean enable) {
        this.preferLateArrival = enable;
        return this;
    }

    public int numberOfAdditionalTransfers() {
        return this.numberOfAdditionalTransfers;
    }

    public SearchParamsBuilder<T> numberOfAdditionalTransfers(int numberOfAdditionalTransfers) {
        this.numberOfAdditionalTransfers = numberOfAdditionalTransfers;
        return this;
    }

    public int maxNumberOfTransfers() {
        return this.maxNumberOfTransfers;
    }

    public SearchParamsBuilder<T> maxNumberOfTransfers(int maxNumberOfTransfers) {
        this.maxNumberOfTransfers = maxNumberOfTransfers;
        return this;
    }

    public double relaxCostAtDestination() {
        return this.relaxCostAtDestination;
    }

    public SearchParamsBuilder<T> relaxCostAtDestination(double relaxCostAtDestination) {
        this.relaxCostAtDestination = relaxCostAtDestination;
        return this;
    }

    public boolean timetableEnabled() {
        return this.timetableEnabled;
    }

    public SearchParamsBuilder<T> timetableEnabled(boolean enable) {
        this.timetableEnabled = enable;
        return this;
    }

    public boolean constrainedTransfersEnabled() {
        return this.constrainedTransfersEnabled;
    }

    public SearchParamsBuilder<T> constrainedTransfersEnabled(boolean enable) {
        this.constrainedTransfersEnabled = enable;
        return this;
    }

    public Collection<RaptorAccessEgress> accessPaths() {
        return this.accessPaths;
    }

    public SearchParamsBuilder<T> addAccessPaths(Collection<? extends RaptorAccessEgress> accessPaths) {
        this.accessPaths.addAll(accessPaths);
        return this;
    }

    public SearchParamsBuilder<T> addAccessPaths(RaptorAccessEgress ... accessPaths) {
        return this.addAccessPaths(Arrays.asList(accessPaths));
    }

    public Collection<RaptorAccessEgress> egressPaths() {
        return this.egressPaths;
    }

    public SearchParamsBuilder<T> addEgressPaths(Collection<? extends RaptorAccessEgress> egressPaths) {
        this.egressPaths.addAll(egressPaths);
        return this;
    }

    public SearchParamsBuilder<T> addEgressPaths(RaptorAccessEgress ... egressPaths) {
        return this.addEgressPaths(Arrays.asList(egressPaths));
    }

    public SearchParamsBuilder<T> allowEmptyEgressPaths(boolean allowEmptyEgressPaths) {
        this.allowEmptyEgressPaths = allowEmptyEgressPaths;
        return this;
    }

    public boolean allowEmptyEgressPaths() {
        return this.allowEmptyEgressPaths;
    }

    public RaptorRequest<T> build() {
        return this.parent.build();
    }

    public SearchParams buildSearchParam() {
        return new SearchParams(this);
    }

    public String toString() {
        return ToStringBuilder.of(SearchParams.class).addServiceTime("earliestDepartureTime", this.earliestDepartureTime, -9999999).addServiceTime("latestArrivalTime", this.latestArrivalTime, -9999999).addDurationSec("searchWindow", this.searchWindowInSeconds).addBoolIfTrue("departAsLateAsPossible", this.preferLateArrival).addNum("numberOfAdditionalTransfers", this.numberOfAdditionalTransfers).addCollection("accessPaths", this.accessPaths, 5).addCollection("egressPaths", this.egressPaths, 5).toString();
    }
}

