/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opentripplanner.transit.raptor.api.debug.DebugEvent;
import org.opentripplanner.transit.raptor.api.debug.DebugLogger;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.request.DebugRequest;
import org.opentripplanner.transit.raptor.api.view.ArrivalView;
import org.opentripplanner.transit.raptor.api.view.PatternRideView;

public class DebugRequestBuilder {
    private final Set<Integer> stops = new HashSet<Integer>();
    private List<Integer> path = new ArrayList<Integer>();
    private int debugPathFromStopIndex;
    private Consumer<DebugEvent<ArrivalView<?>>> stopArrivalListener;
    private Consumer<DebugEvent<PatternRideView<?>>> patternRideDebugListener;
    private Consumer<DebugEvent<Path<?>>> pathFilteringListener;
    private DebugLogger logger;

    DebugRequestBuilder(DebugRequest debug) {
        this.stops.addAll(debug.stops());
        this.path.addAll(debug.path());
        this.debugPathFromStopIndex = debug.debugPathFromStopIndex();
        this.stopArrivalListener = debug.stopArrivalListener();
        this.patternRideDebugListener = debug.patternRideDebugListener();
        this.pathFilteringListener = debug.pathFilteringListener();
        this.logger = debug.logger();
    }

    public List<Integer> stops() {
        return this.stops.stream().sorted().collect(Collectors.toList());
    }

    public DebugRequestBuilder addStops(Collection<Integer> stops) {
        this.stops.addAll(stops);
        return this;
    }

    public DebugRequestBuilder addStops(int ... stops) {
        return this.addStops(Arrays.stream(stops).boxed().collect(Collectors.toList()));
    }

    public List<Integer> path() {
        return this.path;
    }

    public DebugRequestBuilder setPath(List<Integer> stopsInPath) {
        if (!this.path.isEmpty()) {
            throw new IllegalStateException("The API support only one debug path. Existing: " + this.path + ", new: " + stopsInPath);
        }
        this.path = new ArrayList<Integer>(stopsInPath);
        return this;
    }

    public int debugPathFromStopIndex() {
        return this.debugPathFromStopIndex;
    }

    public DebugRequestBuilder debugPathFromStopIndex(int stopIndex) {
        this.debugPathFromStopIndex = stopIndex;
        return this;
    }

    public Consumer<DebugEvent<ArrivalView<?>>> stopArrivalListener() {
        return this.stopArrivalListener;
    }

    public DebugRequestBuilder stopArrivalListener(Consumer<DebugEvent<ArrivalView<?>>> listener) {
        this.stopArrivalListener = listener;
        return this;
    }

    public Consumer<DebugEvent<PatternRideView<?>>> patternRideDebugListener() {
        return this.patternRideDebugListener;
    }

    public DebugRequestBuilder patternRideDebugListener(Consumer<DebugEvent<PatternRideView<?>>> listener) {
        this.patternRideDebugListener = listener;
        return this;
    }

    public Consumer<DebugEvent<Path<?>>> pathFilteringListener() {
        return this.pathFilteringListener;
    }

    public DebugRequestBuilder pathFilteringListener(Consumer<DebugEvent<Path<?>>> listener) {
        this.pathFilteringListener = listener;
        return this;
    }

    public DebugLogger logger() {
        return this.logger;
    }

    public DebugRequestBuilder logger(DebugLogger logger) {
        this.logger = logger;
        return this;
    }

    public DebugRequestBuilder reverseDebugRequest() {
        Collections.reverse(this.path);
        return this;
    }

    public DebugRequest build() {
        return new DebugRequest(List.copyOf(this.stops), List.copyOf(this.path), this.debugPathFromStopIndex, this.stopArrivalListener, this.patternRideDebugListener, this.pathFilteringListener, this.logger);
    }
}

