/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.raptor.api.path;

import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import org.opentripplanner.transit.raptor.api.transit.RaptorAccessEgress;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.util.lang.OtpNumberFormat;
import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.TimeUtils;

public class PathStringBuilder {
    private final RaptorStopNameResolver stopNameResolver;
    private final StringBuilder buf = new StringBuilder();
    private final boolean padDuration;
    private boolean elementAdded = false;
    private boolean sepAdded = false;

    public PathStringBuilder(@Nullable RaptorStopNameResolver stopNameResolver) {
        this(stopNameResolver, false);
    }

    public PathStringBuilder(@Nullable RaptorStopNameResolver stopNameResolver, boolean padDuration) {
        this.stopNameResolver = RaptorStopNameResolver.nullSafe(stopNameResolver);
        this.padDuration = padDuration;
    }

    public PathStringBuilder sep() {
        this.sepAdded = true;
        return this;
    }

    public PathStringBuilder stop(int stopIndex) {
        return this.stop(this.stopNameResolver.apply(stopIndex));
    }

    public PathStringBuilder stop(String stop) {
        return this.start().append(stop).end();
    }

    public PathStringBuilder walk(int duration) {
        return this.start().append("Walk").duration(duration).end();
    }

    public PathStringBuilder flex(int duration, int nRides) {
        return this.start().append("Flex").duration(duration).space().append(nRides).append("x").end();
    }

    public PathStringBuilder accessEgress(RaptorAccessEgress leg) {
        if (leg.hasRides()) {
            return this.flex(leg.durationInSeconds(), leg.numberOfRides());
        }
        return leg.durationInSeconds() == 0 ? this : this.walk(leg.durationInSeconds());
    }

    public PathStringBuilder transit(String description, int fromTime, int toTime) {
        return this.start().append(description).space().time(fromTime, toTime).end();
    }

    public PathStringBuilder transit(String modeName, String trip, ZonedDateTime fromTime, ZonedDateTime toTime) {
        return this.start().append(modeName).space().append(trip).space().time(fromTime, toTime).end();
    }

    public PathStringBuilder street(String modeName, ZonedDateTime fromTime, ZonedDateTime toTime) {
        return this.start().append(modeName).space().time(fromTime, toTime).end();
    }

    public PathStringBuilder timeAndCostCentiSec(int fromTime, int toTime, int generalizedCost) {
        if (this.buf.length() != 0) {
            this.space();
        }
        return this.time(fromTime, toTime).generalizedCostSentiSec(generalizedCost);
    }

    public PathStringBuilder generalizedCostSentiSec(int cost) {
        return this.costCentiSec(cost, 0, null);
    }

    public PathStringBuilder costCentiSec(int cost, int defaultValue, String unit) {
        if (cost == defaultValue) {
            return this;
        }
        this.space().append(OtpNumberFormat.formatCostCenti(cost));
        if (unit != null) {
            this.append(unit);
        }
        return this;
    }

    public PathStringBuilder space() {
        return this.append(" ");
    }

    public PathStringBuilder duration(int duration) {
        String durationStr = DurationUtils.durationToStr(duration);
        return this.space().append(this.padDuration ? String.format("%5s", durationStr) : durationStr);
    }

    public PathStringBuilder time(int from, int to) {
        return this.append(TimeUtils.timeToStrCompact(from)).space().append(TimeUtils.timeToStrCompact(to));
    }

    public PathStringBuilder append(String text) {
        this.buf.append(text);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    private PathStringBuilder time(ZonedDateTime from, ZonedDateTime to) {
        return this.append(TimeUtils.timeToStrCompact(from)).space().append(TimeUtils.timeToStrCompact(to));
    }

    private PathStringBuilder append(int value) {
        this.buf.append(value);
        return this;
    }

    private PathStringBuilder end() {
        this.elementAdded = true;
        this.sepAdded = false;
        return this;
    }

    private PathStringBuilder start() {
        if (this.sepAdded && this.elementAdded) {
            this.append(" ~ ");
        }
        this.elementAdded = false;
        return this;
    }
}

