/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationElement;
import org.opentripplanner.transit.model.site.StopLevel;

public abstract class StationElementBuilder<E extends StationElement<E, B>, B extends StationElementBuilder<E, B>>
extends AbstractEntityBuilder<E, B> {
    private I18NString name;
    private String code;
    private I18NString description;
    private WgsCoordinate coordinate;
    private Accessibility wheelchairAccessibility;
    private StopLevel level;
    private Station parentStation;

    StationElementBuilder(FeedScopedId id) {
        super(id);
    }

    StationElementBuilder(E original) {
        super(original);
        this.name = ((StationElement)original).getName();
        this.code = ((StationElement)original).getCode();
        this.description = ((StationElement)original).getDescription();
        this.coordinate = ((StationElement)original).getCoordinate();
        this.wheelchairAccessibility = ((StationElement)original).getWheelchairAccessibility();
        this.level = ((StationElement)original).level();
        this.parentStation = ((StationElement)original).getParentStation();
    }

    abstract B instance();

    public I18NString name() {
        return this.name;
    }

    public B withName(I18NString name) {
        this.name = name;
        return this.instance();
    }

    public String code() {
        return this.code;
    }

    public B withCode(String code) {
        this.code = code;
        return this.instance();
    }

    public I18NString description() {
        return this.description;
    }

    public B withDescription(I18NString description) {
        this.description = description;
        return this.instance();
    }

    public WgsCoordinate coordinate() {
        return this.coordinate;
    }

    public B withCoordinate(WgsCoordinate coordinate) {
        this.coordinate = coordinate;
        return this.instance();
    }

    public B withCoordinate(double latitude, double longitude) {
        this.coordinate = new WgsCoordinate(latitude, longitude);
        return this.instance();
    }

    public Accessibility wheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public B withWheelchairAccessibility(Accessibility wheelchairAccessibility) {
        this.wheelchairAccessibility = wheelchairAccessibility;
        return this.instance();
    }

    public StopLevel level() {
        return this.level;
    }

    public B withLevel(StopLevel level) {
        this.level = level;
        return this.instance();
    }

    public Station parentStation() {
        return this.parentStation;
    }

    public B withParentStation(Station parentStation) {
        this.parentStation = parentStation;
        return this.instance();
    }
}

