/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.PathwayBuilder;
import org.opentripplanner.transit.model.site.PathwayMode;
import org.opentripplanner.transit.model.site.StationElement;

public final class Pathway
extends AbstractTransitEntity<Pathway, PathwayBuilder> {
    private final PathwayMode pathwayMode;
    private final StationElement<?, ?> fromStop;
    private final StationElement<?, ?> toStop;
    private final String name;
    private final String reversedName;
    private final int traversalTime;
    private final double length;
    private final int stairCount;
    private final double slope;
    private final boolean isBidirectional;

    Pathway(PathwayBuilder builder) {
        super(builder.getId());
        this.pathwayMode = Objects.requireNonNull(builder.pathwayMode());
        this.fromStop = Objects.requireNonNull(builder.fromStop());
        this.toStop = Objects.requireNonNull(builder.toStop());
        this.name = builder.name();
        this.reversedName = builder.reversedName();
        this.traversalTime = builder.traversalTime();
        this.length = builder.length();
        this.stairCount = builder.stairCount();
        this.slope = builder.slope();
        this.isBidirectional = builder.isBidirectional();
    }

    public static PathwayBuilder of(FeedScopedId id) {
        return new PathwayBuilder(id);
    }

    public PathwayMode getPathwayMode() {
        return this.pathwayMode;
    }

    public StationElement<?, ?> getFromStop() {
        return this.fromStop;
    }

    public StationElement<?, ?> getToStop() {
        return this.toStop;
    }

    public String getName() {
        return this.name;
    }

    public String getReversedName() {
        return this.reversedName;
    }

    public int getTraversalTime() {
        return this.traversalTime;
    }

    public double getLength() {
        return this.length;
    }

    public boolean isBidirectional() {
        return this.isBidirectional;
    }

    public int getStairCount() {
        return this.stairCount;
    }

    public double getSlope() {
        return this.slope;
    }

    public boolean isPathwayModeWheelchairAccessible() {
        return this.getPathwayMode() != PathwayMode.STAIRS && this.getPathwayMode() != PathwayMode.ESCALATOR;
    }

    @Override
    public boolean sameAs(@Nonnull Pathway other) {
        return this.getId().equals(other.getId()) && Objects.equals((Object)this.pathwayMode, (Object)other.getPathwayMode()) && Objects.equals(this.fromStop, other.getFromStop()) && Objects.equals(this.toStop, other.getToStop()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.reversedName, other.getReversedName()) && Objects.equals(this.traversalTime, other.getTraversalTime()) && Objects.equals(this.length, other.getLength()) && Objects.equals(this.stairCount, other.getStairCount()) && Objects.equals(this.slope, other.getSlope()) && Objects.equals(this.isBidirectional, other.isBidirectional());
    }

    @Nonnull
    public PathwayBuilder copy() {
        return new PathwayBuilder(this);
    }
}

