/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.organization;

import javax.annotation.Nonnull;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.organization.Agency;

public class AgencyBuilder
extends AbstractEntityBuilder<Agency, AgencyBuilder> {
    private String name;
    private String timezone;
    private String url;
    private String lang;
    private String phone;
    private String fareUrl;
    private String brandingUrl;

    AgencyBuilder(FeedScopedId id) {
        super(id);
    }

    AgencyBuilder(@Nonnull Agency original) {
        super(original);
        this.name = original.getName();
        this.timezone = original.getTimezone().getId();
        this.url = original.getUrl();
        this.lang = original.getLang();
        this.phone = original.getPhone();
        this.fareUrl = original.getFareUrl();
        this.brandingUrl = original.getBrandingUrl();
    }

    public String getName() {
        return this.name;
    }

    public AgencyBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public AgencyBuilder withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public AgencyBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public AgencyBuilder withLang(String lang) {
        this.lang = lang;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public AgencyBuilder withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getFareUrl() {
        return this.fareUrl;
    }

    public AgencyBuilder withFareUrl(String fareUrl) {
        this.fareUrl = fareUrl;
        return this;
    }

    public String getBrandingUrl() {
        return this.brandingUrl;
    }

    public AgencyBuilder withBrandingUrl(String brandingUrl) {
        this.brandingUrl = brandingUrl;
        return this;
    }

    @Override
    protected Agency buildFromValues() {
        return new Agency(this);
    }
}

