/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RoutingTripPattern;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPatternBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.util.geometry.CompactLineStringUtils;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.opentripplanner.util.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TripPattern
extends AbstractTransitEntity<TripPattern, TripPatternBuilder>
implements Cloneable,
LogInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TripPattern.class);
    private final Route route;
    private final StopPattern stopPattern;
    private final Timetable scheduledTimetable;
    private String name;
    private final byte[][] hopGeometries;
    private final TripPattern originalTripPattern;
    private final boolean createdByRealtimeUpdater;
    private final RoutingTripPattern routingTripPattern;

    public TripPattern(TripPatternBuilder builder) {
        super(builder.getId());
        this.name = builder.getName();
        this.route = builder.getRoute();
        this.stopPattern = Objects.requireNonNull(builder.getStopPattern());
        this.createdByRealtimeUpdater = builder.isCreatedByRealtimeUpdate();
        this.scheduledTimetable = builder.getScheduledTimetable() != null ? builder.getScheduledTimetable() : new Timetable(this);
        this.originalTripPattern = builder.getOriginalTripPattern();
        this.hopGeometries = builder.hopGeometries();
        this.routingTripPattern = new RoutingTripPattern(this, builder);
    }

    public static TripPatternBuilder of(@Nonnull FeedScopedId id) {
        return new TripPatternBuilder(id);
    }

    public String getName() {
        return this.name;
    }

    public void initName(String name) {
        this.name = ObjectUtils.requireNotInitialized(this.name, name);
    }

    public Route getRoute() {
        return this.route;
    }

    public TransitMode getMode() {
        return this.route.getMode();
    }

    public LineString getHopGeometry(int stopPosInPattern) {
        if (this.hopGeometries != null) {
            return CompactLineStringUtils.uncompactLineString(this.hopGeometries[stopPosInPattern], false);
        }
        return GeometryUtils.getGeometryFactory().createLineString(new Coordinate[]{TripPattern.coordinate(this.stopPattern.getStop(stopPosInPattern)), TripPattern.coordinate(this.stopPattern.getStop(stopPosInPattern + 1))});
    }

    public StopPattern getStopPattern() {
        return this.stopPattern;
    }

    public void setHopGeometry(int i, LineString hopGeometry) {
        this.hopGeometries[i] = CompactLineStringUtils.compactLineString(hopGeometry, false);
    }

    public LineString getGeometry() {
        if (this.hopGeometries == null || this.hopGeometries.length == 0) {
            return null;
        }
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (int i = 0; i < this.hopGeometries.length; ++i) {
            lineStrings.add(this.getHopGeometry(i));
        }
        return GeometryUtils.concatenateLineStrings(lineStrings);
    }

    public int numHopGeometries() {
        return this.hopGeometries.length;
    }

    public int numberOfStops() {
        return this.stopPattern.getSize();
    }

    public StopLocation getStop(int stopPosInPattern) {
        return this.stopPattern.getStop(stopPosInPattern);
    }

    public StopLocation firstStop() {
        return this.getStop(0);
    }

    public StopLocation lastStop() {
        return this.getStop(this.stopPattern.getSize() - 1);
    }

    public List<StopLocation> getStops() {
        return this.stopPattern.getStops();
    }

    public int findStopPosition(StopLocation stop) {
        return this.stopPattern.findStopPosition(stop);
    }

    public int findBoardingStopPositionInPattern(Station station) {
        return this.stopPattern.findBoardingPosition(station);
    }

    public int findAlightStopPositionInPattern(Station station) {
        return this.stopPattern.findAlightPosition(station);
    }

    public int findBoardingStopPositionInPattern(StopLocation stop) {
        return this.stopPattern.findBoardingPosition(stop);
    }

    public int findAlightStopPositionInPattern(StopLocation stop) {
        return this.stopPattern.findAlightPosition(stop);
    }

    public boolean canAlight(int stopIndex) {
        return this.stopPattern.canAlight(stopIndex);
    }

    public boolean canBoard(int stopIndex) {
        return this.stopPattern.canBoard(stopIndex);
    }

    public boolean canBoard(StopLocation stop) {
        return this.stopPattern.canBoard(stop);
    }

    public boolean canAlight(StopLocation stop) {
        return this.stopPattern.canAlight(stop);
    }

    public boolean wheelchairAccessible(int stopIndex) {
        return this.stopPattern.getStop(stopIndex).getWheelchairAccessibility() == Accessibility.POSSIBLE;
    }

    public PickDrop getAlightType(int stopIndex) {
        return this.stopPattern.getDropoff(stopIndex);
    }

    public PickDrop getBoardType(int stopIndex) {
        return this.stopPattern.getPickup(stopIndex);
    }

    public boolean isBoardAndAlightAt(int stopIndex, PickDrop value) {
        return this.getBoardType(stopIndex).is(value) && this.getAlightType(stopIndex).is(value);
    }

    public boolean stopPatternIsEqual(TripPattern other) {
        return this.stopPattern.equals(other.stopPattern);
    }

    public Trip getTrip(int tripIndex) {
        return this.scheduledTimetable.getTripTimes(tripIndex).getTrip();
    }

    public void add(TripTimes tt) {
        this.scheduledTimetable.addTripTimes(tt);
        if (this.route != tt.getTrip().getRoute()) {
            LOG.warn("The trip {} is on route {} but its stop pattern is on route {}.", new Object[]{tt.getTrip(), tt.getTrip().getRoute(), this.route});
        }
    }

    public void add(FrequencyEntry freq) {
        this.scheduledTimetable.addFrequencyEntry(freq);
        if (this.getRoute() != freq.tripTimes.getTrip().getRoute()) {
            LOG.warn("The trip {} is on a different route than its stop pattern, which is on {}.", (Object)freq.tripTimes.getTrip(), (Object)this.route);
        }
    }

    public void removeTrips(Predicate<Trip> removeTrip) {
        this.scheduledTimetable.getTripTimes().removeIf(tt -> removeTrip.test(tt.getTrip()));
    }

    public boolean isModifiedFromTripPatternWithEqualStops(TripPattern other) {
        return this.originalTripPattern != null && this.originalTripPattern.equals(other) && this.getStopPattern().stopsEqual(other.getStopPattern());
    }

    public Direction getDirection() {
        return this.scheduledTimetable.getDirection();
    }

    public Stream<Trip> scheduledTripsAsStream() {
        Stream<Trip> trips = this.scheduledTimetable.getTripTimes().stream().map(TripTimes::getTrip);
        Stream<Trip> freqTrips = this.scheduledTimetable.getFrequencyEntries().stream().map(e -> e.tripTimes.getTrip());
        return Stream.concat(trips, freqTrips).distinct();
    }

    public Timetable getScheduledTimetable() {
        return this.scheduledTimetable;
    }

    public boolean isCreatedByRealtimeUpdater() {
        return this.createdByRealtimeUpdater;
    }

    public TripPattern getOriginalTripPattern() {
        return this.originalTripPattern;
    }

    public I18NString getTripHeadsign() {
        TripTimes tripTimes = this.scheduledTimetable.getRepresentativeTripTimes();
        if (tripTimes == null) {
            return null;
        }
        return tripTimes.getTrip().getHeadsign();
    }

    public I18NString getStopHeadsign(int stopIndex) {
        TripTimes tripTimes = this.scheduledTimetable.getRepresentativeTripTimes();
        if (tripTimes == null) {
            return null;
        }
        return tripTimes.getHeadsign(stopIndex);
    }

    public boolean matchesModeOrSubMode(TransitMode mode, SubMode transportSubmode) {
        return this.getMode().equals((Object)mode) || this.route.getNetexSubmode().equals(transportSubmode);
    }

    public TripPattern clone() {
        try {
            return (TripPattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFeedId() {
        return this.route.getId().getFeedId();
    }

    public RoutingTripPattern getRoutingTripPattern() {
        return this.routingTripPattern;
    }

    @Override
    public String logName() {
        return this.route.logName();
    }

    private static Coordinate coordinate(StopLocation s) {
        return new Coordinate(s.getLon(), s.getLat());
    }

    @Override
    public boolean sameAs(@Nonnull TripPattern other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.route, other.route) && Objects.equals(this.name, other.name) && Objects.equals(this.stopPattern, other.stopPattern) && Objects.equals(this.scheduledTimetable, other.scheduledTimetable);
    }

    public TripPatternBuilder copy() {
        return new TripPatternBuilder(this);
    }
}

