/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.util.lang.StringUtils;

public final class FeedScopedId
implements Serializable,
Comparable<FeedScopedId> {
    private static final char ID_SEPARATOR = ':';
    private static final long serialVersionUID = 1L;
    private final String feedId;
    private final String id;

    public FeedScopedId(@Nonnull String feedId, @Nonnull String id) {
        this.feedId = StringUtils.assertHasValue(feedId, "Missing mandatory feedId on FeedScopeId", new Object[0]);
        this.id = StringUtils.assertHasValue(id, "Missing mandatory id on FeedScopeId", new Object[0]);
    }

    @Nullable
    public static FeedScopedId ofNullable(@Nonnull String feedId, @Nullable String id) {
        return id == null || id.isBlank() ? null : new FeedScopedId(feedId, id);
    }

    public static FeedScopedId parseId(String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        int index = value.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("invalid feed-scoped-id: " + value);
        }
        return new FeedScopedId(value.substring(0, index), value.substring(index + 1));
    }

    public static boolean isValidString(String value) throws IllegalArgumentException {
        return value != null && value.indexOf(58) > -1;
    }

    public static String concatenateId(String feedId, String id) {
        return feedId + ":" + id;
    }

    public static List<FeedScopedId> parseListOfIds(String s) {
        return Arrays.stream(s.split(",")).map(FeedScopedId::parseId).collect(Collectors.toList());
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public int compareTo(FeedScopedId o) {
        int c = this.feedId.compareTo(o.feedId);
        if (c == 0) {
            c = this.id.compareTo(o.id);
        }
        return c;
    }

    public int hashCode() {
        return this.feedId.hashCode() ^ this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeedScopedId)) {
            return false;
        }
        FeedScopedId other = (FeedScopedId)obj;
        return this.feedId.equals(other.feedId) && this.id.equals(other.id);
    }

    public String toString() {
        return FeedScopedId.concatenateId(this.feedId, this.id);
    }
}

