/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.basic.I18NString;

public class NonLocalizedString
implements I18NString,
Serializable {
    private final String name;

    public NonLocalizedString(@Nonnull String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Nullable
    public static NonLocalizedString ofNullable(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return new NonLocalizedString(name);
    }

    public static <W> NonLocalizedString ofNullable(@Nullable W wrapper, @Nonnull Function<W, String> getValueOp) {
        return wrapper == null ? null : new NonLocalizedString(getValueOp.apply(wrapper));
    }

    public static <W> NonLocalizedString ofNullable(@Nullable W wrapper, @Nonnull Function<W, String> getValueOp, @Nonnull String defaultValue) {
        return new NonLocalizedString(wrapper == null ? defaultValue : getValueOp.apply(wrapper));
    }

    @Nonnull
    public static NonLocalizedString ofNullableOrElse(@Nullable String name, @Nonnull String defaultName) {
        return new NonLocalizedString(name == null ? defaultName : name);
    }

    @Nonnull
    public static I18NString ofNullableOrElse(@Nullable String name, @Nonnull I18NString defaultName) {
        return name == null ? defaultName : new NonLocalizedString(name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof NonLocalizedString)) return false;
        NonLocalizedString that = (NonLocalizedString)other;
        if (!this.name.equals(that.name)) return false;
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String toString(Locale locale) {
        return this.name;
    }
}

