/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.inject.Inject;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.service.TransitModel;

public class MetricsLogging {
    @Inject
    public MetricsLogging(TransitModel transitModel, RaptorConfig<TripSchedule> raptorConfig) {
        new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmCompilationMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmGcMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmHeapPressureMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmInfoMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new LogbackMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        if (transitModel.getTransitLayer() != null) {
            new GuavaCacheMetrics(transitModel.getTransitLayer().getTransferCache().getTransferCache(), "raptorTransfersCache", List.of(Tag.of((String)"cache", (String)"raptorTransfers"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        new ExecutorServiceMetrics((ExecutorService)ForkJoinPool.commonPool(), "commonPool", List.of(Tag.of((String)"pool", (String)"commonPool"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        if (transitModel.getUpdaterManager() != null) {
            new ExecutorServiceMetrics(transitModel.getUpdaterManager().getUpdaterPool(), "graphUpdaters", List.of(Tag.of((String)"pool", (String)"graphUpdaters"))).bindTo((MeterRegistry)Metrics.globalRegistry);
            new ExecutorServiceMetrics((ExecutorService)transitModel.getUpdaterManager().getScheduler(), "graphUpdateScheduler", List.of(Tag.of((String)"pool", (String)"graphUpdateScheduler"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        if (raptorConfig.isMultiThreaded()) {
            new ExecutorServiceMetrics(raptorConfig.threadPool(), "raptorHeuristics", List.of(Tag.of((String)"pool", (String)"raptorHeuristics"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        }
    }
}

