/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import javax.annotation.Nullable;
import javax.ws.rs.core.Application;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.transmodelapi.TransmodelAPI;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.configure.ConstructApplicationFactory;
import org.opentripplanner.standalone.configure.DaggerConstructApplicationFactory;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.standalone.server.OTPWebApplication;
import org.opentripplanner.transit.raptor.configure.RaptorConfig;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.configure.UpdaterConfigurator;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.visualizer.GraphVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructApplication.class);
    private final CommandLineParameters cli;
    private final GraphBuilderDataSources graphBuilderDataSources;
    private final ConstructApplicationFactory factory;

    ConstructApplication(CommandLineParameters cli, Graph graph, TransitModel transitModel, ConfigModel config, GraphBuilderDataSources graphBuilderDataSources) {
        this.cli = cli;
        this.graphBuilderDataSources = graphBuilderDataSources;
        GraphVisualizer graphVisualizer = cli.visualize ? new GraphVisualizer(graph, config.routerConfig().streetRoutingTimeout()) : null;
        this.factory = DaggerConstructApplicationFactory.builder().configModel(config).graph(graph).transitModel(transitModel).graphVisualizer(graphVisualizer).build();
    }

    public ConstructApplicationFactory getFactory() {
        return this.factory;
    }

    public GrizzlyServer createGrizzlyServer() {
        return new GrizzlyServer(this.cli, this.createApplication());
    }

    public GraphBuilder createGraphBuilder() {
        LOG.info("Wiring up and configuring graph builder task.");
        return GraphBuilder.create(this.buildConfig(), this.graphBuilderDataSources, this.graph(), this.transitModel(), this.cli.doLoadStreetGraph(), this.cli.doSaveStreetGraph());
    }

    @Nullable
    public DataSource graphOutputDataSource() {
        return this.graphBuilderDataSources.getOutputGraph();
    }

    private Application createApplication() {
        LOG.info("Wiring up and configuring server.");
        this.setupTransitRoutingServer();
        return new OTPWebApplication(this::createServerContext);
    }

    private void setupTransitRoutingServer() {
        this.factory.metricsLogging();
        ConstructApplication.creatTransitLayerForRaptor(this.transitModel(), this.routerConfig());
        UpdaterConfigurator.configure(this.graph(), this.transitModel(), this.routerConfig().updaterConfig());
        this.graph().initEllipsoidToGeoidDifference();
        if (OTPFeature.SandboxAPITransmodelApi.isOn()) {
            TransmodelAPI.setUp(this.routerConfig().transmodelApi(), this.transitModel(), this.routerConfig().routingRequestDefaults());
        }
        if (OTPFeature.SandboxAPIGeocoder.isOn()) {
            LOG.info("Creating debug client geocoder lucene index");
            LuceneIndex.forServer(this.createServerContext());
        }
    }

    public static void creatTransitLayerForRaptor(TransitModel transitModel, RouterConfig routerConfig) {
        if (!transitModel.hasTransit() || transitModel.getTransitModelIndex() == null) {
            LOG.warn("Cannot create Raptor data, that requires the graph to have transit data and be indexed.");
        }
        LOG.info("Creating transit layer for Raptor routing.");
        transitModel.setTransitLayer(TransitLayerMapper.map(routerConfig.transitTuningParameters(), transitModel));
        transitModel.setRealtimeTransitLayer(new TransitLayer(transitModel.getTransitLayer()));
        transitModel.setTransitLayerUpdater(new TransitLayerUpdater(transitModel, transitModel.getTransitModelIndex().getServiceCodesRunningForDate()));
    }

    public TransitModel transitModel() {
        return this.factory.transitModel();
    }

    public Graph graph() {
        return this.factory.graph();
    }

    public OtpConfig otpConfig() {
        return this.factory.config().otpConfig();
    }

    public RouterConfig routerConfig() {
        return this.factory.config().routerConfig();
    }

    public BuildConfig buildConfig() {
        return this.factory.config().buildConfig();
    }

    public RaptorConfig<TripSchedule> raptorConfig() {
        return this.factory.raptorConfig();
    }

    public GraphVisualizer graphVisualizer() {
        return this.factory.graphVisualizer();
    }

    private OtpServerRequestContext createServerContext() {
        return this.factory.createServerContext();
    }
}

