/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerequest;

import org.opentripplanner.routing.api.request.preference.AccessibilityPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class WheelchairConfig {
    static boolean wheelchairEnabled(NodeAdapter root, String parameterName) {
        return WheelchairConfig.wheelchairRoot(root, parameterName).of("enabled").since(OtpVersion.V2_0).summary("Enable wheelchair accessibility.").asBoolean(false);
    }

    static WheelchairPreferences mapWheelchairPreferences(NodeAdapter root, String parameterName) {
        NodeAdapter a = WheelchairConfig.wheelchairRoot(root, parameterName);
        return new WheelchairPreferences(WheelchairConfig.mapAccessibilityPreferences(a.of("trip").since(OtpVersion.V2_2).summary("Configuration for when to use inaccessible trips.").asObject(), WheelchairPreferences.DEFAULT.trip()), WheelchairConfig.mapAccessibilityPreferences(a.of("stop").since(OtpVersion.V2_2).summary("Configuration for when to use inaccessible stops.").asObject(), WheelchairPreferences.DEFAULT.stop()), WheelchairConfig.mapAccessibilityPreferences(a.of("elevator").since(OtpVersion.V2_2).summary("Configuration for when to use inaccessible elevators.").asObject(), WheelchairPreferences.DEFAULT.elevator()), a.of("inaccessibleStreetReluctance").since(OtpVersion.V2_2).summary("The factor to multiply the cost of traversing a street edge that is not wheelchair-accessible.").asDouble(WheelchairPreferences.DEFAULT.inaccessibleStreetReluctance()), a.of("maxSlope").since(OtpVersion.V2_0).summary("The maximum slope as a fraction of 1.").description("9 percent would be `0.09`").asDouble(WheelchairPreferences.DEFAULT.maxSlope()), a.of("slopeExceededReluctance").since(OtpVersion.V2_2).summary("How much streets with high slope should be avoided.").description("What factor should be given to street edges, which are over the\nmax slope. The penalty is not static but scales with how much you\nexceed the maximum slope. Set to negative to disable routing on\ntoo steep edges.\n").asDouble(WheelchairPreferences.DEFAULT.slopeExceededReluctance()), a.of("stairsReluctance").since(OtpVersion.V2_2).summary("How much stairs should be avoided.").description("Stairs are not completely excluded for wheelchair users but\nseverely punished. This value determines how much they are\npunished. This should be a very high value as you want to only\ninclude stairs as a last result.").asDouble(WheelchairPreferences.DEFAULT.stairsReluctance()));
    }

    static NodeAdapter wheelchairRoot(NodeAdapter root, String parameterName) {
        NodeAdapter a = root.of(parameterName).since(OtpVersion.V2_2).summary("See [Wheelchair Accessibility](Accessibility.md)").asObject();
        return a;
    }

    private static AccessibilityPreferences mapAccessibilityPreferences(NodeAdapter adapter, AccessibilityPreferences defaultValue) {
        Boolean onlyAccessible = adapter.of("onlyConsiderAccessible").since(OtpVersion.V2_2).summary("Whether to only use this entity if it is explicitly marked as wheelchair accessible.").asBoolean(defaultValue.onlyConsiderAccessible());
        int unknownCost = adapter.of("unknownCost").since(OtpVersion.V2_2).summary("The cost to add when traversing an entity with unknown accessibility information.").asInt(600);
        int inaccessibleCost = adapter.of("inaccessibleCost").since(OtpVersion.V2_2).summary("The cost to add when traversing an entity which is know to be inaccessible.").asInt(3600);
        if (onlyAccessible.booleanValue()) {
            return AccessibilityPreferences.ofOnlyAccessible();
        }
        return AccessibilityPreferences.ofCost(unknownCost, inaccessibleCost);
    }
}

