/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters.sources;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSourceParameters;
import org.opentripplanner.ext.vilkkubikerental.VilkkuBikeRentalDataSourceParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.updater.DataSourceType;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.params.VehicleRentalDataSourceParameters;
import org.opentripplanner.util.OtpAppException;

public class VehicleRentalSourceFactory {
    private static final Set<DataSourceType> CONFIG_MAPPING = EnumSet.of(DataSourceType.GBFS, DataSourceType.SMOOVE, DataSourceType.VILKKU);
    private final DataSourceType type;
    private final NodeAdapter c;

    public VehicleRentalSourceFactory(DataSourceType type, NodeAdapter c) {
        this.type = type;
        this.c = c;
    }

    public static VehicleRentalDataSourceParameters create(DataSourceType type, NodeAdapter c) {
        if (!CONFIG_MAPPING.contains((Object)type)) {
            throw new OtpAppException("The updater source type is not supported: " + type);
        }
        return new VehicleRentalSourceFactory(type, c).create();
    }

    public VehicleRentalDataSourceParameters create() {
        return switch (this.type) {
            case DataSourceType.GBFS -> new GbfsVehicleRentalDataSourceParameters(this.url(), this.language(), this.allowKeepingRentedVehicleAtDestination(), this.headers(), this.network());
            case DataSourceType.SMOOVE -> new SmooveBikeRentalDataSourceParameters(this.url(), this.network(), this.allowOverloading(), this.headers());
            case DataSourceType.VILKKU -> new VilkkuBikeRentalDataSourceParameters(this.url(), this.network(), this.allowOverloading(), this.headers());
            default -> new VehicleRentalDataSourceParameters(this.type, this.url(), this.headers());
        };
    }

    private String language() {
        return this.c.of("language").since(OtpVersion.NA).summary("TODO").asString(null);
    }

    private Map<String, String> headers() {
        return this.c.of("headers").since(OtpVersion.NA).summary("HTTP headers to add to the request. Any header key, value can be inserted.").asStringMap();
    }

    private String url() {
        return this.c.of("url").since(OtpVersion.NA).summary("The URL to download the data from.").asString();
    }

    private String network() {
        return this.c.of("network").since(OtpVersion.NA).summary("The name of the network to override the one derived from the source data.").description("GBFS feeds must include a system_id which will be used as the default `network`. These ids are sometimes not helpful so setting this property will override it.").asString(null);
    }

    private boolean allowKeepingRentedVehicleAtDestination() {
        return this.c.of("allowKeepingRentedBicycleAtDestination").since(OtpVersion.NA).summary("If a vehicle should be allowed to be kept at the end of a station-based rental.").description("This behaviour is useful in towns that have only a single rental station. Without it you would need see any results as you would have to always bring it back to the station.").asBoolean(false);
    }

    private boolean allowOverloading() {
        return this.c.of("allowOverloading").since(OtpVersion.NA).summary("Allow leaving vehicles at a station even though there are no free slots.").asBoolean(false);
    }
}

