/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.transit.raptor.api.request.DynamicSearchWindowCoefficients;
import org.opentripplanner.transit.raptor.api.request.RaptorTuningParameters;

public final class TransitRoutingConfig
implements RaptorTuningParameters,
TransitTuningParameters {
    private final int maxNumberOfTransfers;
    private final int scheduledTripBinarySearchThreshold;
    private final int iterationDepartureStepInSeconds;
    private final int searchThreadPoolSize;
    private final int transferCacheMaxSize;
    private final List<Duration> pagingSearchWindowAdjustments;
    private final Map<StopTransferPriority, Integer> stopTransferCost;
    private final DynamicSearchWindowCoefficients dynamicSearchWindowCoefficients;

    public TransitRoutingConfig(String parameterName, NodeAdapter root) {
        NodeAdapter c = root.of(parameterName).since(OtpVersion.NA).summary("Configuration for transit searches with RAPTOR.").description("Some of these parameters for tuning transit routing are only available through configuration and\ncannot be set in the routing request. These parameters work together with the default routing\nrequest and the actual routing request.\n").asObject();
        RaptorTuningParameters dft = new RaptorTuningParameters(){};
        this.maxNumberOfTransfers = c.of("maxNumberOfTransfers").since(OtpVersion.NA).summary("This parameter is used to allocate enough memory space for Raptor.").description("Set it to the maximum number of transfers for any given itinerary expected to be found within the\nentire transit network. The memory overhead of setting this higher than the maximum number of\ntransfers is very little so it is better to set it too high than to low.\n").asInt(dft.maxNumberOfTransfers());
        this.scheduledTripBinarySearchThreshold = c.of("scheduledTripBinarySearchThreshold").since(OtpVersion.NA).summary("This threshold is used to determine when to perform a binary trip schedule search.").description("This reduce the number of trips departure time lookups and comparisons. When testing with data from\nEntur and all of Norway as a Graph, the optimal value was about 50. If you calculate the departure\ntime every time or want to fine tune the performance, changing this may improve the performance a\nfew percents.\n").asInt(dft.scheduledTripBinarySearchThreshold());
        this.iterationDepartureStepInSeconds = c.of("iterationDepartureStepInSeconds").since(OtpVersion.NA).summary("Step for departure times between each RangeRaptor iterations.").description("This is a performance optimization parameter. A transit network usually uses minute resolution for\nthe timetables, so to match that, set this variable to 60 seconds. Setting it to less than 60 will\nnot give better result, but degrade performance. Setting it to 120 seconds will improve performance,\nbut you might get a slack of 60 seconds somewhere in the result.\n").asInt(dft.iterationDepartureStepInSeconds());
        this.searchThreadPoolSize = c.of("searchThreadPoolSize").since(OtpVersion.NA).summary("Split a travel search in smaller jobs and run them in parallel to improve performance.").description("Use this parameter to set the total number of executable threads available across all searches.\nMultiple searches can run in parallel - this parameter have no effect with regard to that. If 0,\nno extra threads are started and the search is done in one thread.\n").asInt(dft.searchThreadPoolSize());
        this.stopTransferCost = c.of("stopTransferCost").since(OtpVersion.NA).summary("Use this to set a stop transfer cost for the given transfer priority").description("The cost is applied to boarding and alighting at all stops. All stops have a transfer cost priority\nset, the default is `allowed`. The `stopTransferCost` parameter is optional, but if listed all\nvalues must be set.\n\nIf not set the `stopTransferCost` is ignored. This is only available for NeTEx imported Stops.\n\nThe cost is a scalar, but is equivalent to the felt cost of riding a transit trip for 1 second.\n\n| Config key    | Description                                                                                   | Type |\n|---------------|-----------------------------------------------------------------------------------------------|:----:|\n| `discouraged` | Use a very high cost like `72 000` to eliminate transfers at the stop if not the only option. | int  |\n| `allowed`     | Allowed, but not recommended. Use something like `150`.                                       | int  |\n| `recommended` | Use a small cost penalty like `60`.                                                           | int  |\n| `preferred`   | The best place to do transfers. Should be set to `0`(zero).                                   | int  |\n\nUse values in a range from `0` to `100 000`. **All key/value pairs are required if the\n`stopTransferCost` is listed.**\n").asEnumMapAllKeysRequired(StopTransferPriority.class, Integer.class);
        this.transferCacheMaxSize = c.of("transferCacheMaxSize").since(OtpVersion.NA).summary("The maximum number of distinct transfers parameters to cache pre-calculated transfers for.").description(" If too low, requests may be slower. If too high, more memory may be used then required.").asInt(25);
        this.pagingSearchWindowAdjustments = c.of("pagingSearchWindowAdjustments").since(OtpVersion.NA).summary("The provided array of durations is used to increase the search-window for the next/previous page.").description("The search window is expanded when the current page return few options. If ZERO result is returned\nthe first duration in the list is used, if ONE result is returned then the second duration is used\nand so on. The duration is added to the existing search-window and inserted into the next and\nprevious page cursor. See JavaDoc for [TransitTuningParameters#pagingSearchWindowAdjustments](https://github.com/opentripplanner/OpenTripPlanner/blob/dev-2.x/src/main/java/org/opentripplanner/routing/algorithm/raptor/transit/TransitTuningParameters.java)\" +\nfor more info.\"\n").asDurations(PAGING_SEARCH_WINDOW_ADJUSTMENTS);
        this.dynamicSearchWindowCoefficients = new DynamicSearchWindowConfig("dynamicSearchWindow", c);
    }

    @Override
    public int maxNumberOfTransfers() {
        return this.maxNumberOfTransfers;
    }

    @Override
    public int scheduledTripBinarySearchThreshold() {
        return this.scheduledTripBinarySearchThreshold;
    }

    @Override
    public int iterationDepartureStepInSeconds() {
        return this.iterationDepartureStepInSeconds;
    }

    @Override
    public int searchThreadPoolSize() {
        return this.searchThreadPoolSize;
    }

    @Override
    public DynamicSearchWindowCoefficients dynamicSearchWindowCoefficients() {
        return this.dynamicSearchWindowCoefficients;
    }

    @Override
    public boolean enableStopTransferPriority() {
        return this.stopTransferCost != null;
    }

    @Override
    public Integer stopTransferCost(StopTransferPriority key) {
        return this.stopTransferCost.get((Object)key);
    }

    @Override
    public int transferCacheMaxSize() {
        return this.transferCacheMaxSize;
    }

    @Override
    public List<Duration> pagingSearchWindowAdjustments() {
        return this.pagingSearchWindowAdjustments;
    }

    private static class DynamicSearchWindowConfig
    implements DynamicSearchWindowCoefficients {
        private final double minTransitTimeCoefficient;
        private final double minWaitTimeCoefficient;
        private final int minWinTimeMinutes;
        private final int maxWinTimeMinutes;
        private final int stepMinutes;

        public DynamicSearchWindowConfig(String parameterName, NodeAdapter root) {
            NodeAdapter dsWin = root.of(parameterName).since(OtpVersion.NA).summary("The dynamic search window coefficients used to calculate the EDT, LAT and SW.").description("The dynamic search window coefficients is used to calculate EDT(*earliest-departure-time*),\nLAT(*latest-arrival-time*) and SW(*raptor-search-window*) request parameters using heuristics. The\nheuristics perform a Raptor search (one-iteration) to find a trip which we use to find a lower\nbound for the travel duration time - the \"minTransitTime\". The heuristic search is used for other\npurposes too, and is very fast.\n\nAt least the EDT or the LAT must be passed into Raptor to perform a Range Raptor search. If\nunknown/missing the parameters(EDT, LAT, DW) are dynamically calculated. The dynamic coefficients\naffect the performance and should be tuned to match the deployment.\n\nThe request parameters are calculated like this:\n\n```\n    DW  = round_N(C + T * minTransitTime + W * minWaitTime)\n    LAT = EDT + DW + minTransitTime\n    EDT = LAT - (DW + minTransitTime)\n```\n\nThe `round_N(...)` method rounds the input to the closest multiplication of N.\n\nThe 3 coefficients above are:\n\n - `C` is parameter: `minWinTimeMinutes`\n - `T` is parameter: `minTransitTimeCoefficient`\n - `W` is parameter: `minWaitTimeCoefficient`\n - `N` is parameter: `stepMinutes`\n\nIn addition there is an upper bound on the calculation of the search window:\n`maxWinTimeMinutes`.\n").asObject();
            DynamicSearchWindowCoefficients dsWinDft = new DynamicSearchWindowCoefficients(){};
            this.minTransitTimeCoefficient = dsWin.of("minTransitTimeCoefficient").since(OtpVersion.NA).summary("The coefficient to multiply with `minTransitTime`.").description("Use a value between `0.0` and `3.0`. Using `0.0` will eliminate the `minTransitTime` from the dynamic raptor-search-window calculation.").asDouble(dsWinDft.minTransitTimeCoefficient());
            this.minWaitTimeCoefficient = dsWin.of("minWaitTimeCoefficient").since(OtpVersion.NA).summary("The coefficient to multiply with `minWaitTime`.").description("Use a value between `0.0` and `1.0`. Using `0.0` will eliminate the `minWaitTime` from the dynamic raptor-search-window calculation.").asDouble(dsWinDft.minWaitTimeCoefficient());
            this.minWinTimeMinutes = dsWin.of("minWinTimeMinutes").since(OtpVersion.NA).summary("The constant minimum number of minutes for a raptor-search-window. ").description("Use a value between 20 and 180 minutes in a normal deployment.").asInt(dsWinDft.minWinTimeMinutes());
            this.maxWinTimeMinutes = dsWin.of("maxWinTimeMinutes").since(OtpVersion.NA).summary("Upper limit for the search-window calculation.").description("Long search windows consumes a lot of resources and may take a long time. Use this parameter to\ntune the desired maximum search time.\n\nThis is the parameter that affect the response time most, the downside is that a search is only\nguaranteed to be pareto-optimal within a search-window.\n\nThe default is 3 hours. The unit is minutes.\n").asInt(dsWinDft.maxWinTimeMinutes());
            this.stepMinutes = dsWin.of("stepMinutes").since(OtpVersion.NA).summary("Used to set the steps the search-window is rounded to.").description("The search window is rounded off to the closest multiplication of `stepMinutes`. If `stepMinutes` =\n10 minutes, the search-window can be 10, 20, 30 ... minutes. It the computed search-window is 5\nminutes and 17 seconds it will be rounded up to 10 minutes.\n\n\nUse a value between `1` and `60`. This should be less than the `min-raptor-search-window`\ncoefficient.\n").asInt(dsWinDft.stepMinutes());
        }

        @Override
        public double minTransitTimeCoefficient() {
            return this.minTransitTimeCoefficient;
        }

        @Override
        public double minWaitTimeCoefficient() {
            return this.minWaitTimeCoefficient;
        }

        @Override
        public int minWinTimeMinutes() {
            return this.minWinTimeMinutes;
        }

        @Override
        public int maxWinTimeMinutes() {
            return this.maxWinTimeMinutes;
        }

        @Override
        public int stepMinutes() {
            return this.stepMinutes;
        }
    }
}

