/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.framework.json;

import java.util.EnumSet;
import org.opentripplanner.standalone.config.framework.json.ConfigType;
import org.opentripplanner.standalone.config.framework.json.NodeInfo;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

class NodeInfoBuilder {
    private String name;
    private ConfigType type;
    private Class<? extends Enum<?>> enumType;
    private ConfigType elementType;
    private OtpVersion since = OtpVersion.NA;
    private String summary = "TODO: Add short summary.";
    private String description = null;
    private String defaultValue = null;
    private boolean required = true;
    private boolean skipChildren = false;

    NodeInfoBuilder() {
    }

    public String name() {
        return this.name;
    }

    NodeInfoBuilder withName(String name) {
        this.name = name;
        return this;
    }

    NodeInfoBuilder withType(ConfigType type) {
        if (EnumSet.of(ConfigType.ARRAY, ConfigType.MAP, ConfigType.ENUM_MAP, ConfigType.ENUM_SET, ConfigType.ENUM).contains((Object)type)) {
            throw new IllegalArgumentException("Use type specific build methods for this type like 'withArray'. Type : " + type);
        }
        this.type = type;
        return this;
    }

    NodeInfoBuilder withSince(OtpVersion since) {
        this.since = since;
        return this;
    }

    public NodeInfoBuilder withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    NodeInfoBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    NodeInfoBuilder withOptional(String defaultValue) {
        this.defaultValue = defaultValue;
        return this.withOptional();
    }

    NodeInfoBuilder withOptional() {
        this.required = false;
        return this;
    }

    NodeInfoBuilder withRequired() {
        this.required = true;
        return this;
    }

    NodeInfoBuilder withEnum(Class<? extends Enum<?>> enumType) {
        this.type = ConfigType.ENUM;
        this.enumType = enumType;
        return this;
    }

    NodeInfoBuilder withArray(ConfigType elementType) {
        this.type = ConfigType.ARRAY;
        this.elementType = elementType;
        return this;
    }

    NodeInfoBuilder withMap(ConfigType elementType) {
        this.type = ConfigType.MAP;
        this.elementType = elementType;
        return this;
    }

    NodeInfoBuilder withEnumMap(Class<? extends Enum<?>> enumType, ConfigType elementType) {
        this.type = ConfigType.ENUM_MAP;
        this.enumType = enumType;
        this.elementType = elementType;
        return this;
    }

    NodeInfoBuilder withEnumSet(Class<? extends Enum<?>> enumType) {
        this.type = ConfigType.ENUM_SET;
        this.elementType = ConfigType.ENUM;
        this.enumType = enumType;
        return this;
    }

    NodeInfoBuilder withSkipChild() {
        this.skipChildren = true;
        return this;
    }

    NodeInfo build() {
        return new NodeInfo(this.name, this.summary, this.description, this.type, this.enumType, this.elementType, this.since, this.defaultValue, this.required, this.skipChildren);
    }
}

